/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend;

import com.meidusa.venus.backend.ShutdownListener;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusStatus {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownListener.class);
    private static final String PS_OLD_GEN = "PS Old Gen";
    private static long OOMCount = 0L;
    private static VenusStatus instance = new VenusStatus();
    private static ShutdownListener listener = new ShutdownListener();
    private byte status = 1;

    public static VenusStatus getInstance() {
        return instance;
    }

    private VenusStatus() {
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public static void main(String[] args) throws Exception {
        ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : list) {
            System.out.println("------" + bean.getName() + "--------");
            MemoryUsage usage = bean.getUsage();
            System.out.println(bean);
            System.out.println(usage);
        }
        List<GarbageCollectorMXBean> gcList = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean mxBean : gcList) {
            mxBean.getMemoryPoolNames();
            System.out.println("name=" + mxBean.getName() + ",times=" + mxBean.getCollectionCount() + ",time=" + mxBean.getCollectionTime());
        }
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        System.out.println(osBean.getSystemLoadAverage());
    }

    static {
        Runtime.getRuntime().addShutdownHook(listener);
        new Thread(){
            {
                this.setDaemon(true);
                this.setName("VM-OOM-Checker");
            }

            @Override
            public void run() {
                while (true) {
                    List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
                    for (MemoryPoolMXBean bean : list) {
                        if (!StringUtils.equalsIgnoreCase((String)bean.getName(), (String)VenusStatus.PS_OLD_GEN)) continue;
                        MemoryUsage usage = bean.getUsage();
                        double freeRate = (double)(usage.getMax() - usage.getUsed()) / (double)usage.getMax();
                        if (freeRate <= 1.0E-7) {
                            OOMCount++;
                            if (OOMCount <= 10L) continue;
                            if (VenusStatus.getInstance().getStatus() == 1) {
                                VenusStatus.getInstance().setStatus((byte)4);
                            }
                            logger.warn(bean.getName() + ":" + usage);
                            continue;
                        }
                        OOMCount = 0L;
                        VenusStatus.getInstance().setStatus((byte)(0xFFFFFFFB & VenusStatus.getInstance().getStatus() & 0xFF));
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }
}

