/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend;

import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.InvocationObserver;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.interceptor.InterceptorMapping;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.notify.InvocationListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultEndpointInvocation
implements EndpointInvocation {
    protected Iterator<InterceptorMapping> interceptors;
    private static String ENDPOINT_INVOKED = "invoke endpoint: ";
    private boolean executed;
    private Object result;
    private Endpoint endpoint;
    private RequestContext context;
    private EndpointInvocation.ResultType type = EndpointInvocation.ResultType.RESPONSE;
    private List<InvocationObserver> observerList = new ArrayList<InvocationObserver>();

    public DefaultEndpointInvocation(RequestContext context, Endpoint endpoint) {
        this.endpoint = endpoint;
        if (endpoint.getInterceptorStack() != null) {
            this.interceptors = endpoint.getInterceptorStack().getInterceptors().iterator();
        }
        this.context = context;
    }

    public void addObserver(InvocationObserver observer) {
        if (!this.observerList.contains(observer)) {
            this.observerList.add(observer);
        }
    }

    @Override
    public RequestContext getContext() {
        return this.context;
    }

    public EndpointInvocation.ResultType getType() {
        return this.type;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object invoke() {
        if (this.executed) {
            throw new IllegalStateException("Request has already executed");
        }
        if (this.interceptors != null && this.interceptors.hasNext()) {
            InterceptorMapping interceptor = this.interceptors.next();
            String interceptorMsg = "interceptor: " + interceptor.getName();
            UtilTimerStack.push(interceptorMsg);
            try {
                this.result = interceptor.getInterceptor().intercept(this);
            }
            finally {
                UtilTimerStack.pop(interceptorMsg);
            }
        }
        try {
            try {
                UtilTimerStack.push(ENDPOINT_INVOKED);
                Object[] parameters = this.getContext().getEndPointer().getParameterValues(this.getContext().getParameters());
                if (this.getEndpoint().isAsync()) {
                    this.type = EndpointInvocation.ResultType.NONE;
                }
                Object[] objectArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof InvocationListener) {
                        this.type = EndpointInvocation.ResultType.NOTIFY;
                    }
                    ++n2;
                }
                for (InvocationObserver observer : this.observerList) {
                    observer.beforeInvoke(this, this.getContext());
                }
                this.result = this.invokeEndpoint(this.getEndpoint(), parameters);
                for (InvocationObserver observer : this.observerList) {
                    observer.afterInvoke(this, this.getContext());
                }
            }
            finally {
                UtilTimerStack.pop(ENDPOINT_INVOKED);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServiceInvokeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new ServiceInvokeException(e.getTargetException());
            }
            throw new ServiceInvokeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceInvokeException((Throwable)e);
        }
        if (!this.executed) {
            this.executed = true;
        }
        return this.result;
    }

    protected Object invokeEndpoint(Endpoint endPoint, Object[] parameters) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Object instance = endPoint.getService().getInstance();
        Object result = this.getEndpoint().getMethod().invoke(instance, parameters);
        return result;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }
}

