package com.meidusa.venus.backend.network.handler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.backend.network.VenusClientConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServiceNofityPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.Utils;

public class RemotingInvocationListener<T> implements InvocationListener<T> {
	private static Logger logger = LoggerFactory.getLogger(RemotingInvocationListener.class);
	private VenusClientConnection conn;
	private ReferenceInvocationListener<T> source;
	private boolean isResponsed = false;
	private AbstractServicePacket request;
	public boolean isResponsed() {
		return isResponsed;
	}
	public RemotingInvocationListener(VenusClientConnection conn,ReferenceInvocationListener<T> source,AbstractServicePacket request){
		this.conn = conn;
		this.source = source;
		this.request = request;
	}
	@Override
	public void callback(T object) {
		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
		ServiceNofityPacket response = new SerializeServiceNofityPacket(serializer,null);
		AbstractServicePacket.copyHead(request, response);
    	response.callbackObject = object;
    	response.identityData = source.getIdentityData();
    	conn.postMessage(response.toByteBuffer());
    	isResponsed = true;
	}
	
	@Override
	public void onException(Exception e) {
		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
		ServiceNofityPacket response = new SerializeServiceNofityPacket(serializer,null);
		AbstractServicePacket.copyHead(request, response);
		if(e instanceof CodedException){
			CodedException codedException = (CodedException)e;
			response.errorCode = codedException.getErrorCode();
		}
		
    	if(e != null){
    		Map<String,PropertyDescriptor> mpd = Utils.getBeanPropertyDescriptor(e.getClass());
    		Map<String,Object> additionalData = new HashMap<String,Object>();
    		
    		for(Map.Entry<String, PropertyDescriptor> entry : mpd.entrySet()){
    			try {
					additionalData.put(entry.getKey(),entry.getValue().getReadMethod().invoke(e));
				} catch (Exception e1) {
					logger.error("read bean properpty error",e1);
				}
    		}
    		response.additionalData = serializer.encode(additionalData);
    	}
    	
		response.errorMessage = e.getMessage();
    	response.identityData = source.getIdentityData();
    	conn.postMessage(response.toByteBuffer());
    	isResponsed = true;
	}

}
