package com.meidusa.venus.backend.network;

import java.nio.channels.SocketChannel;

import com.meidusa.toolkit.net.AbstractConnectionFactory;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;

/**
 * 
 * @author struct
 *
 */
public class VenusClientConnectionFactory extends AbstractConnectionFactory {
    private MessageHandler<VenusClientConnection> messageHandler;
    
    public MessageHandler<VenusClientConnection> getMessageHandler() {
        return messageHandler;
    }

    public void setMessageHandler(MessageHandler<VenusClientConnection> messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    protected Connection newConnectionInstance(SocketChannel channel, long createStamp) {
        Connection conn = new VenusClientConnection(channel, createStamp);
        conn.setMessageHandler(messageHandler);
        return conn;
    }
}
