package com.meidusa.venus.backend.authenticate;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.DummyAuthenticateProvider;
import com.meidusa.toolkit.net.packet.AbstractPacket;
import com.meidusa.venus.exception.VenusExceptionCodeConstant;
import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.PasswordAuthenPacket;

public class SimpleAuthenticateProvider extends DummyAuthenticateProvider implements PacketConstant{
	private static Logger logger = LoggerFactory.getLogger(SimpleAuthenticateProvider.class);
	private String username;
	private String password;
	private boolean useDummy = true;
	public boolean isUseDummy() {
		return useDummy;
	}
	
	public void setUseDummy(boolean useDummy) {
		this.useDummy = useDummy;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@Override
	protected void processAuthentication(AuthingableConnection conn,
			@SuppressWarnings("rawtypes") AbstractPacket authenPacket, AuthResponseData rdata) {
		if(this.isUseDummy()){
			super.processAuthentication(conn, authenPacket, rdata);
		}else{
			if(authenPacket instanceof PasswordAuthenPacket){
				HandshakePacket handshake = (HandshakePacket)conn.getStep(1);
				PasswordAuthenPacket passPacket = (PasswordAuthenPacket)authenPacket;
				boolean isSuccess = false;
				if(StringUtils.equals(this.username, passPacket.username)){
					isSuccess = true;
				}
				if(isSuccess){
					byte[] pBytes = PasswordAuthenPacket.encryptPasswd(password, handshake.challenge);
					isSuccess = ArrayUtils.isEquals(pBytes, passPacket.encryptedPasswd);
				}
				if(isSuccess){
					rdata.code = AuthResponseData.SUCCESS;
				}else{
					rdata.code = VenusExceptionCodeConstant.AUTHEN_EXCEPTION;
					rdata.message = "username or password error";
				}
				
				if(logger.isInfoEnabled()){
					logger.info("Accepting authenticate request: conn=" + conn.getId() +", using PasswordAuthen, result="+isSuccess);
				}
				return;
			} else if(authenPacket instanceof DummyAuthenPacket){
				rdata.code = VenusExceptionCodeConstant.AUTHEN_EXCEPTION;
				rdata.message = " Dummy authentication not support!!";
				if(logger.isInfoEnabled()){
					logger.info("Accepting authenticate request: conn=" + conn.getId() +", with "+rdata.message+", result=false");
				}
				return;
			}else{
				rdata.code = VenusExceptionCodeConstant.AUTHEN_EXCEPTION;
				rdata.message = " Unknown the authentication type ";
				if(logger.isInfoEnabled()){
					logger.info("Accepting authenticate request: conn=" + conn.getId() +", with "+rdata.message+", result=false");
				}
			}
		}

	}
	
}
