package com.meidusa.venus.backend.services.xml;

import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.log4j.Logger;
import org.ini4j.MultiMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ResourceUtils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meidusa.venus.common.monitor.MonitorRuntime;
import com.meidusa.venus.common.monitor.MonitorService;
import com.meidusa.venus.common.monitor.ServerStatus;
import com.meidusa.venus.common.monitor.service.ServiceBean;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.annotations.PerformanceLevel;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.backend.interceptor.Configurable;
import com.meidusa.venus.backend.interceptor.Interceptor;
import com.meidusa.venus.backend.interceptor.InterceptorMapping;
import com.meidusa.venus.backend.interceptor.InterceptorStack;
import com.meidusa.venus.backend.interceptor.config.InterceptorConfig;
import com.meidusa.venus.backend.services.AbstractServiceManager;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.SingletonService;
import com.meidusa.venus.backend.services.xml.bean.EndpointConfig;
import com.meidusa.venus.backend.services.xml.bean.InterceptorRef;
import com.meidusa.venus.backend.services.xml.bean.InterceptorStackConfig;
import com.meidusa.venus.backend.services.xml.bean.InterceptorStackRef;
import com.meidusa.venus.backend.services.xml.bean.PerformanceLogger;
import com.meidusa.venus.backend.services.xml.bean.ServiceConfig;
import com.meidusa.venus.backend.services.xml.bean.Venus;
import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.util.StringUtil;

public class XmlFileServiceManager extends AbstractServiceManager implements InitializingBean, BeanFactoryAware {
	private static Logger logger = Logger.getLogger(XmlFileServiceManager.class);
	private String[] configFiles;
	private BeanFactory beanFactory;
	private BeanContext beanContext;

	public String[] getConfigFiles() {
		return configFiles;
	}

	public void setConfigFiles(String[] configFiles) {
		this.configFiles = configFiles;
	}

	public void init() {

	}

	@Override
	public void afterPropertiesSet() throws Exception {

		beanContext = new BeanContext() {
			public Object getBean(String beanName) {
				if (beanFactory != null) {
					return beanFactory.getBean(beanName);
				} else {
					return null;
				}
			}

			public Object createBean(Class clazz) throws Exception {
				if(beanFactory instanceof AutowireCapableBeanFactory){
					AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)beanFactory;
					Object object = factory.autowire(clazz, AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, false);
					return object;
				}
				return null;
			}
		};
		BeanContextBean.getInstance().setBeanContext(beanContext);
		BeanUtilsBean.setInstance(new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()) {
			@SuppressWarnings("unchecked")
			public void setProperty(Object bean, String name, Object value) throws IllegalAccessException,
					InvocationTargetException {
				if (value instanceof String) {
					PropertyDescriptor descriptor = null;
					try {
						descriptor = getPropertyUtils().getPropertyDescriptor(bean, name);
						if (descriptor == null) {
							return; // Skip this property setter
						} else {
							if (descriptor.getPropertyType().isEnum()) {
								Class<Enum> clazz = (Class<Enum>) descriptor.getPropertyType();
								value = Enum.valueOf(clazz, (String) value);
							} else {
								Object temp = null;
								try {
									temp = ConfigUtil.filter((String) value, beanContext);
								} catch (Exception e) {
								}
								if (temp == null) {
									temp = ConfigUtil.filter((String) value);
								}
								value = temp;
							}
						}
					} catch (NoSuchMethodException e) {
						return; // Skip this property setter
					}
				}
				super.setProperty(bean, name, value);
			}

		});

		List<ServiceConfig> serviceConfigList = new ArrayList<ServiceConfig>();
		Map<String, InterceptorMapping> interceptors = new HashMap<String, InterceptorMapping>();
		Map<String, InterceptorStackConfig> interceptorStatcks = new HashMap<String, InterceptorStackConfig>();

		
		for (String configFile : configFiles) {
			configFile = (String) ConfigUtil.filter(configFile);
			RuleSet ruleSet = new FromXmlRuleSet(this.getClass().getResource("venusServerRule.xml"),
					new DigesterRuleParser());
			Digester digester = new Digester();
			digester.addRuleSet(ruleSet);

			try {
				InputStream is = ResourceUtils.getURL(configFile.trim()).openStream();
				Venus venus = (Venus) digester.parse(is);
				serviceConfigList.addAll(venus.getServiceConfigs());
				interceptors.putAll(venus.getInterceptors());
				interceptorStatcks.putAll(venus.getInterceptorStatcks());
			} catch (Exception e) {
				throw new ConfigurationException("can not parser xml:" + configFile, e);
			}
		}

		for (ServiceConfig config : serviceConfigList) {
			Service service = loadService(config,interceptors,interceptorStatcks);
			Map<String, Collection<Endpoint>> ends = service.getEndpoints().asMap();
			for(Map.Entry<String, Collection<Endpoint>> entry : ends.entrySet()){
				if(entry.getValue() != null && !entry.getValue().isEmpty()){
					MonitorRuntime.getInstance().initEndPoint(service.getName(),entry.getValue().iterator().next().getName());
				}
			}
		}
		
		ServiceConfig monitorServiceConfig = new ServiceConfig();
		monitorServiceConfig.setActive(true);
		monitorServiceConfig.setType(MonitorService.class);
		monitorServiceConfig.setInstance(new MonitorService(){

			@Override
			public List<ServiceBean> getSerivces() {
				List<ServiceBean> list = new ArrayList<ServiceBean>();
				list.addAll(MonitorRuntime.getInstance().getServiceMap().values());
				return list;
			}

			@Override
			public ServerStatus getServerStatus() {
				ServerStatus status = new ServerStatus();
				status.setUptime(MonitorRuntime.getInstance().getUptime());
				return status;
			}

			@Override
			public String getVersion() {
				return PacketConstant.VENUS_VERSION;
			}
			
		});
		
		loadService(monitorServiceConfig,interceptors,interceptorStatcks);
	}
	
	
	protected Service loadService(ServiceConfig config,Map<String, InterceptorMapping> interceptors,Map<String, InterceptorStackConfig> interceptorStatcks){
		SingletonService service = new SingletonService();
		service.setType(config.getType());
		service.setInstance(config.getInstance());
		Class<?> type = config.getType();
		type.cast(config.getInstance());
		service.setActive(config.isActive());
		service.setVersionRange(config.getVersionRange());

		com.meidusa.venus.annotations.Service serviceAnnotation = type
				.getAnnotation(com.meidusa.venus.annotations.Service.class);

		if (!serviceAnnotation.name().isEmpty()) {
			service.setName(serviceAnnotation.name());
		} else {
			service.setName(type.getCanonicalName());
		}

		// cache all methods
		Method[] methods = service.getType().getMethods();
		Multimap<String, Endpoint> endpoints = HashMultimap.create();
		for (Method method : methods) {
			if (method.isAnnotationPresent(com.meidusa.venus.annotations.Endpoint.class)) {
				Endpoint ep = loadEndpoint(method);

				EndpointConfig endpointConfig = config.getEndpointConfig(ep.getName());
				if (endpointConfig != null) {
					ep.setActive(endpointConfig.isActive());
					String id = endpointConfig.getInterceptorStack();
					Map<String, InterceptorConfig> interceptorConfigs = endpointConfig.getInterceptorConfigs();

					// ignore 'null' or empty intercept stack name
					if (!StringUtil.isEmpty(id) && !"null".equalsIgnoreCase(id)) {
						List<InterceptorMapping> list = new ArrayList<InterceptorMapping>();
						InterceptorStackConfig stackConfig = interceptorStatcks.get(id);
						if (stackConfig == null) {
							throw new VenusConfigException("interceptor stack not found with name=" + id);
						}
						InterceptorStack stack = new InterceptorStack();
						stack.setName(stackConfig.getName());

						loadInterceptors(interceptorStatcks, interceptors, id, list, interceptorConfigs,
								service.getType(), ep.getName());
						stack.setInterceptors(list);
						ep.setInterceptorStack(stack);
					}
					
					
				}
				
				PerformanceLogger pLogger =  null;
				if(endpointConfig != null){
					pLogger = endpointConfig.getPerformanceLogger();
				}
				 	
				if(pLogger == null){
					PerformanceLevel pLevel = AnnotationUtil.getAnnotation(ep.getMethod().getAnnotations(), PerformanceLevel.class);
					if(pLevel != null){
						pLogger = new PerformanceLogger();
						pLogger.setError(pLevel.error());
						pLogger.setInfo(pLevel.info());
						pLogger.setWarn(pLevel.warn());
						pLogger.setPrintParams(pLevel.printParams());
					}
				}
				ep.setPerformanceLogger(pLogger);
				
				ep.setService(service);
				if (logger.isInfoEnabled()) {
					logger.info("Add Endpoint: " + ep.getService().getName()+"."+ep.getName());
				}
				endpoints.put(ep.getName(), ep);
			}
		}
		service.setEndpoints(endpoints);

		this.services.put(service.getName(), service);

		// register to resolvable dependency container

		if (beanFactory instanceof ConfigurableListableBeanFactory) {
			ConfigurableListableBeanFactory cbf = (ConfigurableListableBeanFactory) beanFactory;
			cbf.registerResolvableDependency(service.getType(), service.getInstance());
		}
		return service;
	}

	protected void loadInterceptors(Map<String, InterceptorStackConfig> interceptorStatcks,
			Map<String, InterceptorMapping> interceptors, String id, List<InterceptorMapping> result,
			Map<String, InterceptorConfig> configs, Class<?> clazz, String ep) throws VenusConfigException {
		InterceptorStackConfig stackConfig = interceptorStatcks.get(id);
		if (stackConfig == null) {
			throw new VenusConfigException("interceptor stack not found with name=" + id);
		}
		for (Object s : stackConfig.getInterceptors()) {
			if (s instanceof InterceptorRef) {
				InterceptorMapping mapping = interceptors.get(((InterceptorRef) s).getName());
				if (mapping == null) {
					throw new VenusConfigException("interceptor not found with name=" + s);
				}
				Interceptor interceptor = mapping.getInterceptor();
				InterceptorConfig config = configs.get(mapping.getName());
				if (config != null) {
					if(interceptor instanceof Configurable){
						((Configurable)interceptor).processConfig(clazz, ep, config);
					}
				}
				result.add(mapping);
			} else if (s instanceof InterceptorStackRef) {
				loadInterceptors(interceptorStatcks, interceptors, ((InterceptorStackRef) s).getName(), result, configs, clazz, ep);
			} else {
				throw new VenusConfigException("unknow interceptor config with name=" + s);
			}
		}
	}

	@Override
	public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
		this.beanFactory = beanFactory;
	}

}
