/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class Utils {
    public static boolean arrayEquals(String[] s1, String[] s2) {
        Object[] s1Copy = Arrays.copyOf(s1, s1.length);
        Object[] s2Copy = Arrays.copyOf(s2, s2.length);
        Arrays.sort(s1Copy);
        Arrays.sort(s2Copy);
        return Arrays.equals(s1Copy, s2Copy);
    }

    private static boolean arrayContains1(String[] parent, String[] child) {
        if (child.length == 0) {
            return true;
        }
        Object[] parentCopy = Arrays.copyOf(parent, parent.length);
        Object[] childCopy = Arrays.copyOf(child, child.length);
        Arrays.sort(parentCopy);
        Arrays.sort(childCopy);
        int i = 0;
        int j = 0;
        while (i < parentCopy.length && j < childCopy.length) {
            if (((String)childCopy[j]).equals(parentCopy[i])) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        return i == parentCopy.length;
    }

    public static <T> T[] subArray(T[] original, Predication<T> predication) {
        ArrayList<T> container = new ArrayList<T>(original.length);
        for (T item : original) {
            if (!predication.predict(item)) continue;
            container.add(item);
        }
        return container.toArray(Arrays.copyOf(original, 0));
    }

    public static String toString(Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (Object k : map.keySet()) {
            sb.append(k.toString());
            sb.append(":");
            sb.append(map.get(k));
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean arrayContains(String[] parent, String[] child) {
        if (parent == null || parent.length == 0) {
            return true;
        }
        Arrays.sort(child);
        for (String i : parent) {
            if (Arrays.binarySearch(child, i) >= 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        int i;
        String[] s1 = new String[]{"name", "hello", "abcd", "qwer", "qwerqweraa", "maf3", "123"};
        String[] s2 = new String[]{"hdkje", "abcd", "qwer", "ouidb", "qwerqweraa", "heoidyhh", "maf3", "837dbb", "123", "name", "hello"};
        boolean result = false;
        result = Utils.arrayContains1(s1, s2);
        long start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = Utils.arrayContains1(s1, s2);
        }
        System.out.println("result=" + result + "," + (System.currentTimeMillis() - start));
        result = Utils.arrayContains(s1, s2);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = Utils.arrayContains(s1, s2);
        }
        System.out.println("result=" + result + "," + (System.currentTimeMillis() - start));
    }

    public static interface Predication<T> {
        public boolean predict(T var1);
    }
}

