/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.venus.backend.network.VenusClientConnection;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import java.io.Serializable;

public class RemotingInvocationListener<T extends Serializable>
implements InvocationListener<T> {
    private VenusClientConnection conn;
    private ReferenceInvocationListener<T> source;
    private boolean isResponsed = false;
    private AbstractServicePacket request;

    public boolean isResponsed() {
        return this.isResponsed;
    }

    public RemotingInvocationListener(VenusClientConnection conn, ReferenceInvocationListener<T> source, AbstractServicePacket request) {
        this.conn = conn;
        this.source = source;
        this.request = request;
    }

    public void callback(T object) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        response.callbackObject = object;
        response.identityData = this.source.getIdentityData();
        this.conn.postMessage(response.toByteBuffer());
        this.isResponsed = true;
    }

    public void onException(Exception e) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        if (e instanceof CodedException) {
            CodedException codedException = (CodedException)e;
            response.errorCode = codedException.getErrorCode();
        }
        response.errorMessage = e.getMessage();
        response.identityData = this.source.getIdentityData();
        this.conn.postMessage(response.toByteBuffer());
        this.isResponsed = true;
    }
}

