/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.interceptor;

import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.interceptor.AbstractInterceptor;
import com.meidusa.venus.backend.interceptor.config.ScheduleConfig;
import com.meidusa.venus.backend.interceptor.config.SyslogConfig;
import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.LogEventHandler;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.util.IpUtil;
import java.util.concurrent.TimeUnit;

public abstract class MonitorInterceptor
extends AbstractInterceptor {
    private ScheduleConfig scheduleConfig = new ScheduleConfig();
    private SyslogConfig syslogConfig;

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public void setScheduleConfig(ScheduleConfig scheduleConfig) {
        this.scheduleConfig = scheduleConfig;
    }

    public SyslogConfig getSyslogConfig() {
        return this.syslogConfig;
    }

    public void setSyslogConfig(SyslogConfig syslogConfig) {
        this.syslogConfig = syslogConfig;
    }

    void initLogEventHandler(String categaoryName) {
        LogEventHandler logHandler = new LogEventHandler(categaoryName);
        if (this.syslogConfig != null) {
            logHandler.configSyslog(this.syslogConfig.getSyslogHost(), this.syslogConfig.getPattern(), this.syslogConfig.getLevel());
        }
        this.putHandler(logHandler);
    }

    void initScheduler(Runnable task) {
        GlobalScheduler globalScheduler = GlobalScheduler.getInstance();
        globalScheduler.scheduleWithFixedDelay(task, this.scheduleConfig.getInitialDelay(), this.scheduleConfig.getDelay(), TimeUnit.SECONDS);
    }

    @Override
    public Object intercept(EndpointInvocation invocation) {
        MonitorKey key = new MonitorKey();
        key.setInterfaceName(invocation.getEndpoint().getName());
        key.setParamNums(invocation.getEndpoint().getParameters().length);
        this.setMonitorType(key);
        Monitor monitor = this.acquireMonitor(key);
        MonitorContext context = new MonitorContext();
        context.setAppId(invocation.getContext().getClientId());
        context.setMoniteeName(invocation.getEndpoint().getName());
        context.setServerIp(IpUtil.getLocalServerIp());
        monitor.setMonitorContext(context);
        EndpointInvocation target = (EndpointInvocation)monitor.monitor((Object)invocation);
        return target.invoke();
    }

    @Override
    public void init() throws InitialisationException {
        super.init();
    }

    abstract void putHandler(LogEventHandler var1);

    abstract void setMonitorType(MonitorKey var1);

    abstract Monitor acquireMonitor(MonitorKey var1);
}

