/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.authenticate;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.DummyAuthenticateProvider;
import com.meidusa.toolkit.net.packet.AbstractPacket;
import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.PasswordAuthenPacket;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SimpleAuthenticateProvider
extends DummyAuthenticateProvider
implements PacketConstant {
    private static Logger logger = Logger.getLogger(SimpleAuthenticateProvider.class);
    private String username;
    private String password;
    private boolean useDummy = true;

    public boolean isUseDummy() {
        return this.useDummy;
    }

    public void setUseDummy(boolean useDummy) {
        this.useDummy = useDummy;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void processAuthentication(AuthingableConnection conn, AbstractPacket authenPacket, AuthResponseData rdata) {
        if (this.isUseDummy()) {
            super.processAuthentication(conn, authenPacket, rdata);
        } else {
            if (authenPacket instanceof PasswordAuthenPacket) {
                HandshakePacket handshake = (HandshakePacket)conn.getStep(1);
                PasswordAuthenPacket passPacket = (PasswordAuthenPacket)authenPacket;
                boolean isSuccess = false;
                if (StringUtils.equals((String)this.username, (String)passPacket.username)) {
                    isSuccess = true;
                }
                if (isSuccess) {
                    byte[] pBytes = PasswordAuthenPacket.encryptPasswd((String)this.password, (String)handshake.challenge);
                    isSuccess = ArrayUtils.isEquals((Object)pBytes, (Object)passPacket.encryptedPasswd);
                }
                if (isSuccess) {
                    rdata.code = 0;
                } else {
                    rdata.code = 18004000;
                    rdata.message = "username or password error";
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Accepting authenticate request: conn=" + conn.getId() + ", using PasswordAuthen, result=" + isSuccess));
                }
                return;
            }
            if (authenPacket instanceof DummyAuthenPacket) {
                rdata.code = 18004000;
                rdata.message = " Dummy authentication not support!!";
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Accepting authenticate request: conn=" + conn.getId() + ", with " + rdata.message + ", result=false"));
                }
                return;
            }
            rdata.code = 18004000;
            rdata.message = " Unknown the authentication type ";
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Accepting authenticate request: conn=" + conn.getId() + ", with " + rdata.message + ", result=false"));
            }
        }
    }
}

