package com.meidusa.venus.backend.network.handler;

import java.io.Serializable;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.backend.network.VenusClientConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServiceNofityPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;

public class RemotingInvocationListener<T extends Serializable> implements InvocationListener<T> {
	private VenusClientConnection conn;
	private ReferenceInvocationListener<T> source;
	private boolean isResponsed = false;
	private AbstractServicePacket request;
	public boolean isResponsed() {
		return isResponsed;
	}
	public RemotingInvocationListener(VenusClientConnection conn,ReferenceInvocationListener<T> source,AbstractServicePacket request){
		this.conn = conn;
		this.source = source;
		this.request = request;
	}
	@Override
	public void callback(T object) {
		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
		ServiceNofityPacket response = new SerializeServiceNofityPacket(serializer,null);
		AbstractServicePacket.copyHead(request, response);
    	response.callbackObject = object;
    	response.identityData = source.getIdentityData();
    	conn.postMessage(response.toByteBuffer());
    	isResponsed = true;
	}
	
	@Override
	public void onException(Exception e) {
		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
		ServiceNofityPacket response = new SerializeServiceNofityPacket(serializer,null);
		AbstractServicePacket.copyHead(request, response);
		if(e instanceof CodedException){
			CodedException codedException = (CodedException)e;
			response.errorCode = codedException.getErrorCode();
		}
		response.errorMessage = e.getMessage();
    	response.identityData = source.getIdentityData();
    	conn.postMessage(response.toByteBuffer());
    	isResponsed = true;
	}

}
