/**
 * 
 */
package com.meidusa.venus.backend.interceptor;



import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.MonitorManager;
import com.meidusa.venus.monitor.event.EventHandlerManager;
import com.meidusa.venus.monitor.event.LogEventHandler;
import com.meidusa.venus.monitor.impl.PerformanceMonitorFactory;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.model.MonitorType;
import com.meidusa.venus.monitor.model.PerformanceMonitorData;
import com.meidusa.venus.monitor.runnable.PerformanceCheck;
import com.meidusa.toolkit.common.bean.util.InitialisationException;

/**
 * @author gaoyong
 *
 */
public class PerformanceInterceptor extends MonitorInterceptor {
	
	private int latency;

	public int getLatency() {
		return latency;
	}

	public void setLatency(int latency) {
		this.latency = latency;
	}

	@Override
	public void init() throws InitialisationException {
		super.init();
		PerformanceMonitorData.latencyThreshold = latency;
		initLogEventHandler(PerformanceInterceptor.class.getName());
		initScheduler(new PerformanceCheck());
	}

	@Override
	void putHandler(LogEventHandler logHandler) {
		EventHandlerManager.addHandlers(MonitorType.PERFORMANCE, logHandler);	
	}

	@Override
	void setMonitorType(MonitorKey key) {
		key.setMonitorType(MonitorType.PERFORMANCE);	
	}

	@Override
	Monitor acquireMonitor(MonitorKey key) {
		MonitorManager monitorManager = new MonitorManager(PerformanceMonitorFactory.getInstance());
		return monitorManager.getMonitor(key);
	}

}
