/**
 * 
 */
package com.meidusa.venus.backend.interceptor;

import java.util.concurrent.TimeUnit;

import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.interceptor.config.ScheduleConfig;
import com.meidusa.venus.backend.interceptor.config.SyslogConfig;
import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.LogEventHandler;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.util.IpUtil;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.runtime.GlobalScheduler;

/**
 * @author gaoyong
 * 
 */
public abstract class MonitorInterceptor extends AbstractInterceptor {

	private ScheduleConfig scheduleConfig = new ScheduleConfig();

	private SyslogConfig syslogConfig;

	public ScheduleConfig getScheduleConfig() {
		return scheduleConfig;
	}

	public void setScheduleConfig(ScheduleConfig scheduleConfig) {
		this.scheduleConfig = scheduleConfig;
	}

	public SyslogConfig getSyslogConfig() {
		return syslogConfig;
	}

	public void setSyslogConfig(SyslogConfig syslogConfig) {
		this.syslogConfig = syslogConfig;
	}

	void initLogEventHandler(String categaoryName){
		LogEventHandler logHandler = new LogEventHandler(categaoryName);
		if(syslogConfig!=null){
			logHandler.configSyslog(syslogConfig.getSyslogHost(), syslogConfig.getPattern(), syslogConfig.getLevel());
		}
		putHandler(logHandler);
	}
	
	
	
	void initScheduler(Runnable task){
		GlobalScheduler globalScheduler = GlobalScheduler.getInstance();
		globalScheduler.scheduleWithFixedDelay(task, scheduleConfig.getInitialDelay(), scheduleConfig.getDelay(), TimeUnit.SECONDS);
	}
	
	@Override
	public Object intercept(EndpointInvocation invocation) {
		MonitorKey key = new MonitorKey();
		key.setInterfaceName(invocation.getEndpoint().getName());
		key.setParamNums(invocation.getEndpoint().getParameters().length);
		setMonitorType(key);
		
		Monitor monitor = acquireMonitor(key);
		MonitorContext context = new MonitorContext();
		context.setAppId(invocation.getContext().getClientId());
		context.setMoniteeName(invocation.getEndpoint().getName());
		context.setServerIp(IpUtil.getLocalServerIp());
		monitor.setMonitorContext(context);
		
		EndpointInvocation target = (EndpointInvocation) monitor.monitor(invocation);

		return target.invoke();
	}
	
	@Override
	public void init() throws InitialisationException {
		super.init();
	}
	
	abstract void putHandler(LogEventHandler logHandler);
	
	abstract void setMonitorType(MonitorKey key);
	
	abstract Monitor acquireMonitor(MonitorKey key);

}
