/**
 * 
 */
package com.meidusa.venus.backend.interceptor;



import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.MonitorManager;
import com.meidusa.venus.monitor.event.EventHandlerManager;
import com.meidusa.venus.monitor.event.LogEventHandler;
import com.meidusa.venus.monitor.impl.ExceptionMonitorFactory;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.model.MonitorType;
import com.meidusa.venus.monitor.runnable.ExceptionCheck;
import com.meidusa.toolkit.common.bean.util.InitialisationException;


/**
 * @author gaoyong
 *
 */
public class ExceptionInterceptor extends MonitorInterceptor{
	
	@Override
	public void init() throws InitialisationException {
		super.init();
		initLogEventHandler(ExceptionInterceptor.class.getName());
		initScheduler(new ExceptionCheck());
	}

	@Override
	void putHandler(LogEventHandler logHandler) {
		EventHandlerManager.addHandlers(MonitorType.EXCEPTION, logHandler);	
	}

	@Override
	void setMonitorType(MonitorKey key) {
		key.setMonitorType(MonitorType.EXCEPTION);	
	}

	@Override
	Monitor acquireMonitor(MonitorKey key) {
		MonitorManager monitorManager = new MonitorManager(ExceptionMonitorFactory.getInstance());
		return monitorManager.getMonitor(key);
	}
	
}
