package com.meidusa.venus.service.registry;

import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.meidusa.toolkit.common.util.ObjectUtil;

/**
 * 
 * @author structchen
 *
 */
public class ServiceDefinition {
	
	/**
	 * 
	 */
	private String name;
	
	/**
	 * 汾Χ
	 */
	private String versionRange;
	
	/**
	 * ǷActive״̬
	 */
	private boolean active;
	
	/**
	 * ÷ڵķipַб(ʽ=host:port)
	 */
	private Set<String> ipAddress;

	public String getName() {
		return name;
	}

	public Set<String> getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(Set<String> ipAddress) {
		this.ipAddress = ipAddress;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getVersionRange() {
		return versionRange;
	}

	public void setVersionRange(String versionRange) {
		this.versionRange = versionRange;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public boolean equals(Object obj){
		if(obj == this){
			return true;
		}
		if(obj instanceof ServiceDefinition){
			ServiceDefinition target = (ServiceDefinition)obj;
			boolean result = StringUtils.equals(name, target.getName());
			result = result && StringUtils.equals(versionRange, target.getVersionRange());
			result = result && this.getIpAddress() != null && target.getIpAddress().equals(this.getIpAddress());
			result = result &&  ObjectUtil.equals(active, target.isActive());
			return result;
		}
		
		return false;
	}
}
