package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.packet.GenericIOPacketBuffer;
import com.meidusa.toolkit.net.util.InetAddressUtil;

public class VenusRouterPacket extends AbstractVenusPacket {
    /**
     * connection Sequence id in router packet
     */
    public static final int CONNECTION_SEQUENCE_ID = VENUS_HEADER_LENGTH + 4;

    /**
     * connection Sequence id in router packet
     */
    public static final int FRONTEND_REQUEST_ID = CONNECTION_SEQUENCE_ID + 8;

    /**
     * connection Sequence id in router packet
     */
    public static final int BACKEND_REQUEST_ID = FRONTEND_REQUEST_ID + 8;

    public static final int VENUS_ROUTER_PACKET_DATA_POSITION = BACKEND_REQUEST_ID + 8 + 1;

    private static final long serialVersionUID = 1L;

    /**
     * 璇ユ暟鎹寘鐨勫師濮嬫暟鎹唴瀹癸紝璇ュ瓧娈典笉鍙備笌鏁版嵁浼犺緭锛屽彧鏄�鍔╄瀵硅薄杩涜鏁版嵁浼犻�
     */
    public transient byte[] original;

    /**
     * 瀹㈡埛绔殑鍘熷IP
     * 
     * @see InetAddressUtil#pack(byte[])
     */
    public int srcIP;

    /**
     * 瀹㈡埛绔殑鍦℉SB涓殑閾炬帴ID鏍囪瘑
     */
    public long frontendConnectionID;

    /**
     * Frontend connection RequestID in bus
     */
    public long frontendRequestID;

    /**
     * Backend connection RequestID in bus
     */
    public long backendRequestID;

    /**
     * 鍦ㄥ鎴风缁忚繃hsb鐨勬墍鏈夋暟鎹寘锛岃鍙傛暟鍒欎唬琛ㄦ渶鍒濈殑璇锋眰鏂规墍閲囩敤鐨勫簭鍒楀寲鏂瑰紡銆�
     * 濡傛灉鏈嶅姟绔帴鏀跺埌VenusRouterPacket绫诲瀷鐨勬暟鎹寘锛屽簭鍒楀寲鏂瑰紡鍒欎互璇ュ瓧娈典负鍑嗐� 鍏朵粬鏁版嵁鍖呭垯浠�connection涓殑serializeType涓哄噯
     */
    public byte serializeType = -1;

    /**
     * 璺敱鏁版嵁鍖呬腑锛岃瀛楁浠ｈ〃瀹㈡埛绔姹傜殑鏁版嵁鍖呭唴瀹癸紙涓�璇锋眰鐨勬暣浣撻�杈戞暟鎹寘锛�
     */
    public byte[] data;

    public VenusRouterPacket() {
        this.type = PACKET_TYPE_ROUTER;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        srcIP = buffer.readInt();
        frontendConnectionID = buffer.readLong();
        frontendRequestID = buffer.readLong();
        backendRequestID = buffer.readLong();
        serializeType = buffer.readByte();
        data = buffer.readRemaining();
        buffer.setPosition(buffer.getPosition() + data.length);
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        buffer.writeInt(srcIP);
        buffer.writeLong(frontendConnectionID);
        buffer.writeLong(frontendRequestID);
        buffer.writeLong(backendRequestID);
        buffer.writeByte(serializeType);
        buffer.writeBytes(data);

    }

    public static ByteBuffer toByteBuffer(VenusRouterPacket packet) {

        byte[] result = toByteArray(packet);
        return AbstractPacketBuffer.toByteBuffer(result, 0, result.length);
    }

    public static byte[] toByteArray(VenusRouterPacket packet) {
        int position = 4;
        byte[] result = new byte[39 + packet.data.length];

        // header
        position = GenericIOPacketBuffer.writeShort(result, position, PROTOCOL_VERSION);
        position = GenericIOPacketBuffer.writeInt(result, position, packet.type);

        // router
        position = GenericIOPacketBuffer.writeInt(result, position, packet.srcIP);
        position = GenericIOPacketBuffer.writeLong(result, position, packet.frontendConnectionID);
        position = GenericIOPacketBuffer.writeLong(result, position, packet.frontendRequestID);
        position = GenericIOPacketBuffer.writeLong(result, position, packet.backendRequestID);
        result[position++] = packet.serializeType;

        System.arraycopy(packet.data, 0, result, position, packet.data.length);

        // write packet length
        GenericIOPacketBuffer.writeInt(result, 0, result.length);
        return result;
    }

    @Override
    protected int calculatePacketSize() {
        return 42;
    }

    @Override
    protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }

    public static long getConnectionSequenceID(byte[] buf) {
        return GenericIOPacketBuffer.readLong(buf, CONNECTION_SEQUENCE_ID);
    }

    public static long getSourceRequestID(byte[] buf) {
        return GenericIOPacketBuffer.readLong(buf, FRONTEND_REQUEST_ID);
    }

    public static long getRemoteRequestID(byte[] buf) {
        return GenericIOPacketBuffer.readLong(buf, BACKEND_REQUEST_ID);
    }

    public static byte[] getData(byte[] message) {
        byte[] bts = new byte[message.length - VENUS_ROUTER_PACKET_DATA_POSITION];
        System.arraycopy(message, VENUS_ROUTER_PACKET_DATA_POSITION, bts, 0, bts.length);
        return bts;
    }

}
