/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.serializer.bson;

import com.meidusa.fastbson.FastBsonSerializer;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.parse.ByteArrayBSONScanner;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.serializer.AbstractSerializer;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class FastBsonSerializerWrapper
extends AbstractSerializer {
    private FastBsonSerializer serializer = new FastBsonSerializer();

    static {
        FastBsonSerializer.registerReplace(InvocationListener.class, ReferenceInvocationListener.class);
    }

    @Override
    public void encode(ServicePacketBuffer buffer, Object obj) {
        BSONWriter writer = this.serializer.encode(obj);
        buffer.writeInt(writer.getLength());
        buffer.writeBytes(writer.getBuffer(), 0, writer.getLength());
    }

    @Override
    public Object decode(ServicePacketBuffer buffer, Type type) {
        return this.decode(buffer.readLengthCodedBytes(), type);
    }

    @Override
    public Map<String, Object> decode(ServicePacketBuffer buffer, Map<String, Type> typeMap) {
        return this.decode(buffer.readLengthCodedBytes(), typeMap);
    }

    @Override
    public Map<String, Object> decode(byte[] buffer, Map<String, Type> typeMap) {
        ByteArrayBSONScanner scanner = new ByteArrayBSONScanner(buffer);
        scanner.skip(4);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        while (scanner.readType() != 0) {
            String field = scanner.readCString();
            Type type = typeMap.get(field);
            if (type != null) {
                returnMap.put(field, this.serializer.decode((BSONScanner)scanner, type));
                continue;
            }
            scanner.skipValue();
        }
        return returnMap;
    }

    @Override
    public byte[] encode(Object obj) {
        BSONWriter writer = this.serializer.encode(obj);
        return ArrayUtils.subarray((byte[])writer.getBuffer(), (int)0, (int)writer.getLength());
    }

    @Override
    public Object decode(byte[] bts, Type type) {
        ByteArrayBSONScanner scanner = new ByteArrayBSONScanner(bts);
        return this.serializer.decode((BSONScanner)scanner, type);
    }
}

