package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.packet.GenericIOPacketBuffer;
import com.meidusa.toolkit.net.util.InetAddressUtil;

public class VenusRouterPacket  extends AbstractVenusPacket{
	/**
     * connection Sequence id in router packet
     */
    public static final int CONNECTION_SEQUENCE_ID = VENUS_HEADER_LENGTH + 4;
    
    /**
     * connection Sequence id in router packet
     */
    public static final int FRONTEND_REQUEST_ID = CONNECTION_SEQUENCE_ID+8;
    
    /**
     * connection Sequence id in router packet
     */
    public static final int BACKEND_REQUEST_ID = FRONTEND_REQUEST_ID+8;
    
    public static final int VENUS_ROUTER_PACKET_DATA_POSITION = BACKEND_REQUEST_ID+8+1;
    
	private static final long serialVersionUID = 1L;
	
	/**
	 * ݰԭʼݣֶβݴ䣬ֻǽöݴ
	 */
	public transient byte[] original;
	
	/**
	 * ͻ˵ԭʼIP
	 * @see InetAddressUtil#pack(byte[])
	 */
	public int srcIP;
	
	/**
	 * ͻ˵HSBеIDʶ
	 */
	public long frontendConnectionID;
	
	/**
	 * Frontend connection RequestID in bus
	 */
	public long frontendRequestID;
	
	/**
	 * Backend connection RequestID in bus
	 */
	public long backendRequestID;
	
	/**
	 * ڿͻ˾hsbݰòõлʽ
	 * ˽յVenusRouterPacket͵ݰлʽԸֶΪ׼
	 * ݰ connectionеserializeTypeΪ׼
	 */
	public byte serializeType = -1;
	
	/**
	 * ·ݰУֶδͻݰݣһ߼ݰ
	 */
	public byte[] data;
	
	public VenusRouterPacket(){
		this.type = PACKET_TYPE_ROUTER;
	}
	
	@Override
	protected void readBody(ServicePacketBuffer buffer) {
		srcIP = buffer.readInt();
		frontendConnectionID = buffer.readLong();
		frontendRequestID = buffer.readLong();
		backendRequestID = buffer.readLong();
		serializeType = buffer.readByte();
		data = buffer.readRemaining();
		buffer.setPosition(buffer.getPosition()+data.length);
	}

	@Override
	protected void writeBody(ServicePacketBuffer buffer)
			throws UnsupportedEncodingException {
		buffer.writeInt(srcIP);
		buffer.writeLong(frontendConnectionID);
		buffer.writeLong(frontendRequestID);
		buffer.writeLong(backendRequestID);
		buffer.writeByte(serializeType);
		buffer.writeBytes(data);
		
	}

	public static ByteBuffer toByteBuffer(VenusRouterPacket packet){
		
		byte[] result = toByteArray(packet);
		return AbstractPacketBuffer.toByteBuffer(result, 0, result.length);
	}
	
	public static byte[] toByteArray(VenusRouterPacket packet){
		int position = 4;
		byte[] result = new byte[39+packet.data.length];
		
		//header
		position = GenericIOPacketBuffer.writeShort(result, position, PROTOCOL_VERSION);
		position = GenericIOPacketBuffer.writeInt(result, position, packet.type);
		
		//router
		position = GenericIOPacketBuffer.writeInt(result, position, packet.srcIP);
		position = GenericIOPacketBuffer.writeLong(result, position, packet.frontendConnectionID);
		position = GenericIOPacketBuffer.writeLong(result, position, packet.frontendRequestID);
		position = GenericIOPacketBuffer.writeLong(result, position, packet.backendRequestID);
		result[position++] = packet.serializeType;
		
		System.arraycopy(packet.data, 0, result, position, packet.data.length);
		
		//write packet length
		GenericIOPacketBuffer.writeInt(result, 0, result.length);
		return result;
	}
	
	@Override
	protected int calculatePacketSize() {
		return 42;
	}

	@Override
	 protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }
	
    public static long getConnectionSequenceID(byte[] buf) {
    	return GenericIOPacketBuffer.readLong(buf, CONNECTION_SEQUENCE_ID);
    }
    
    public static long getSourceRequestID(byte[] buf) {
    	return GenericIOPacketBuffer.readLong(buf, FRONTEND_REQUEST_ID);
    }
    
    public static long getRemoteRequestID(byte[] buf) {
    	return GenericIOPacketBuffer.readLong(buf, BACKEND_REQUEST_ID);
    }
    
    public static byte[] getData(byte[] message) {
    	byte[] bts = new byte[message.length - VENUS_ROUTER_PACKET_DATA_POSITION];
		System.arraycopy(message, VENUS_ROUTER_PACKET_DATA_POSITION, bts, 0, bts.length);
		return bts;
    }
    
    public static void main(String[] args){
    	VenusRouterPacket packet = new VenusRouterPacket();
    	packet.frontendConnectionID = 11;
    	packet.frontendRequestID = 11111;
    	packet.backendRequestID = 12;
    	packet.serializeType = 1;
    	packet.srcIP = 1001;
    	packet.data = new byte[10];
    	
    	ByteBuffer buffer = toByteBuffer(packet);
    	
    	VenusRouterPacket other = new VenusRouterPacket();
    	
    	other.init(packet.toByteArray());
    	
    	System.out.println(other);
    	
    }
}
