package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;

public abstract class ServiceNofityPacket extends AbstractServicePacket {
	private static final long serialVersionUID = 1L;
	public byte[] identityData;
	public int errorCode;
	public String errorMessage;
	
	public Object callbackObject;
	public ServiceNofityPacket(){
		this.type = PACKET_TYPE_NOTIFY_PUBLISH;
	}
	
	protected void readBody(ServicePacketBuffer buffer) {
		super.readBody(buffer);
		identityData = buffer.readLengthCodedBytes();
		errorCode = buffer.readInt();
		if(errorCode != 0){
			errorMessage = buffer.readLengthCodedString(PACKET_CHARSET);
		}else{
			callbackObject = readCallBackObject(buffer);
		}
	}
	
	protected abstract Object readCallBackObject(ServicePacketBuffer buffer);
	
	protected abstract void writeCallBackObject(ServicePacketBuffer buffer,Object callbackObject);
	
	@Override
	protected void writeBody(ServicePacketBuffer buffer)
			throws UnsupportedEncodingException {
		super.writeBody(buffer);
		buffer.writeLengthCodedBytes(identityData);
		buffer.writeInt(errorCode);
		if(errorCode != 0){
			buffer.writeLengthCodedString(errorMessage, PACKET_CHARSET);
		}else{
			writeCallBackObject(buffer,callbackObject);
		}
	}

}
