package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;
import java.util.Map;


/**
 * 
 * @author Struct
 *
 */
public class AbstractServiceRequestPacket extends AbstractServicePacket {

    private static final long serialVersionUID = 1L;
    public String sourceClientId;
    public String soureIpAddress;
    public String apiName;
    public int serviceVersion;
    public Map<String, Object> parameterMap;
	public AbstractServiceRequestPacket() {
        type = PACKET_TYPE_SERVICE_REQUEST;
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
    	super.writeBody(buffer);
    	buffer.writeLengthCodedString(sourceClientId, PacketConstant.PACKET_CHARSET);
    	buffer.writeLengthCodedString(soureIpAddress, PacketConstant.PACKET_CHARSET);
        buffer.writeLengthCodedString(apiName, PacketConstant.PACKET_CHARSET);
        buffer.writeInt(serviceVersion);
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
    	super.readBody(buffer);
    	sourceClientId = buffer.readLengthCodedString(PacketConstant.PACKET_CHARSET);
    	soureIpAddress = buffer.readLengthCodedString(PacketConstant.PACKET_CHARSET);
        apiName = buffer.readLengthCodedString(PacketConstant.PACKET_CHARSET);
        serviceVersion = buffer.readInt();
    }
    
    protected int calculatePacketSize() {
        return super.calculatePacketSize()+64;
    }
    
}
