package com.meidusa.venus.exception;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.log4j.Logger;

import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.xml.ExceptionConfig;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;

public class XmlVenusExceptionFactory implements VenusExceptionFactory {
	private static Logger logger = Logger.getLogger(XmlVenusExceptionFactory.class);
	private Map<Integer,ExceptionConfig> codeMap = new HashMap<Integer,ExceptionConfig>();
	private Map<Class,ExceptionConfig> classMap = new HashMap<Class,ExceptionConfig>();
	
	private static ReflectionProvider reflectionProvider = PureJavaReflectionProvider.getInstance();
	private String[] configFiles;
	
	
	public String[] getConfigFiles() {
		return configFiles;
	}


	public void setConfigFiles(String[] configFiles) {
		this.configFiles = configFiles;
	}

	public void addException(Class<? extends CodedException> clazz){
		CodedException exception = (CodedException)reflectionProvider.newInstance(clazz);
		ExceptionConfig config = new ExceptionConfig();
		config.setErrorCode(exception.getErrorCode());
		config.setType(clazz);
		codeMap.put(config.getErrorCode(), config);
		classMap.put(clazz, config);
	}

	@Override
	public Exception getException(int errcode, String message) {
		ExceptionConfig config = codeMap.get(errcode);
		if(config == null){
			return new DefaultVenusException(errcode,message);
		}else{
			Constructor[] constructors = null;
			try {
				constructors = config.getType().getConstructors();
				for(Constructor constructor:constructors){
					if(Modifier.isPublic(constructor.getModifiers())){
						Class type[] = constructor.getParameterTypes();
						if(type.length == 1 ){
							if(type[0] == String.class){
								try {
									return (Exception) constructor.newInstance(message);
								} catch (Exception e) {
									logger.error("create exception instance error", e);
									return new DefaultVenusException(errcode,"create exception instance error",e);
								}
							}
						}else if(type.length == 2){
							if(type[0] == String.class && type[1] == Throwable.class){
								try {
									return (Exception) constructor.newInstance(new Object[]{message,null});
								} catch (Exception e) {
									logger.error("create exception instance error", e);
									return new DefaultVenusException(errcode,"create exception instance error",e);
								}
							}else if(type[0] == Throwable.class && type[1] == String.class){
								try {
									return (Exception) constructor.newInstance(new Object[]{null,message});
								} catch (Exception e) {
									logger.error("create exception instance error", e);
									return new DefaultVenusException(errcode,"create exception instance error",e);
								}
							}
						}else if(type.length ==0){
							try {
								return (Exception) constructor.newInstance();
							} catch (Exception e) {
								logger.error("create exception instance error", e);
								return new DefaultVenusException(errcode,"create exception instance error",e);
							}
						}
					}
				}
			} catch (SecurityException e) {
				logger.error("exception new instance error",e);
			} 
		}
		
		return new DefaultVenusException(errcode,message);
	}

	@Override
	public int getErrorCode(Class<? extends Throwable> clazz) {
		ExceptionConfig config = classMap.get(clazz);
		if(config != null){
			return config.getErrorCode();
		}
		return 0;
		
	}
	
	public void init(){
		RuleSet ruleSet = new FromXmlRuleSet(this.getClass().getResource("VenusSystemExceptionRule.xml"),new DigesterRuleParser());
		for (String configFile : configFiles) {
			configFile = (String)ConfigUtil.filter(configFile);
			
	        Digester digester = new Digester();
	        digester.addRuleSet(ruleSet);
	        
			try {
				InputStream is = null;
				if(configFile.startsWith("classpath:")){
					configFile = configFile.substring("classpath:".length());
					is = this.getClass().getClassLoader().getResourceAsStream(configFile);
				}else{ 
					is = new FileInputStream(new File(configFile));
				}
				List<ExceptionConfig> list = (List<ExceptionConfig>) digester.parse(is);
				for(ExceptionConfig config: list){
					codeMap.put(config.getErrorCode(), config);
					classMap.put(config.getType(), config);
				}
			}catch(Exception e){
				logger.error("parser VenusSystemExceptionRule.xml error",e);
			}
		}
	}



}
