/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util.concurrent;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.util.concurrent.DefaultMultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiBlockingQueueExecutor;
import com.meidusa.venus.util.concurrent.MultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiQueueRunnable;
import com.meidusa.venus.util.concurrent.MultipleQueue;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MultiLinkedBlockingQueue<E extends MultiQueueRunnable>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable,
MultipleQueue {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger nodeCount = new AtomicInteger(0);
    private transient Node<Tuple<QueueConfig, Queue<E>>> head;
    private transient Node<Tuple<QueueConfig, Queue<E>>> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();
    private MultiQueueManager<E> manager;
    private Map<String, Node<Tuple<QueueConfig, Queue<E>>>> nodeMap = new HashMap<String, Node<Tuple<QueueConfig, Queue<E>>>>();

    public void setManager(MultiQueueManager<E> manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }

    private void enqueue(E x) {
        Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple((Named)x);
        ((MultiQueueRunnable)x).setQueue(this, tuple);
        ((Queue)tuple.right).add(x);
        this.putTupleIntoQueue(tuple);
    }

    private void putTupleIntoQueue(Tuple<QueueConfig, Queue<E>> tuple) {
        String name = ((QueueConfig)tuple.left).getName();
        if (((QueueConfig)tuple.left).getRunningSize() < ((QueueConfig)tuple.left).getMaxActive() && ((Queue)tuple.right).size() > 0 && !((QueueConfig)tuple.left).isInWaiting()) {
            Node<Tuple<QueueConfig, Queue<Tuple<QueueConfig, Queue<E>>>>> node = new Node<Tuple<QueueConfig, Queue<Tuple<QueueConfig, Queue<E>>>>>(tuple);
            this.last.next = node;
            this.last = this.last.next;
            int count = this.nodeCount.getAndIncrement();
            ((QueueConfig)tuple.left).setInWaiting(true);
            if (!this.takeLock.isHeldByCurrentThread()) {
                this.signalNotEmpty();
            } else {
                this.notEmpty.signal();
            }
        }
    }

    private E dequeue() {
        Tuple item = null;
        MultiQueueRunnable x = null;
        while (this.nodeCount.get() > 0) {
            Node<Tuple<QueueConfig, Queue<E>>> h = this.head;
            Node first = h.next;
            this.head = first;
            item = (Tuple)first.item;
            ((QueueConfig)item.left).setInWaiting(false);
            this.nodeCount.decrementAndGet();
            first.item = null;
            if (((QueueConfig)item.left).getRunningSize() >= ((QueueConfig)item.left).getMaxActive() || ((Queue)item.right).size() <= 0) continue;
            try {
                x = (MultiQueueRunnable)((Queue)item.right).poll();
                break;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return (E)x;
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    boolean isFullyLocked() {
        return this.putLock.isHeldByCurrentThread() && this.takeLock.isHeldByCurrentThread();
    }

    public MultiLinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public MultiLinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLinkedBlockingQueue(Collection<? extends E> c) {
        this(Integer.MAX_VALUE);
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            int n = 0;
            for (MultiQueueRunnable e : c) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (n == this.capacity) {
                    throw new IllegalStateException("Queue full");
                }
                super.enqueue(e);
                ++n;
            }
            this.count.set(n);
        }
        finally {
            putLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int c = -1;
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            while (count.get() == this.capacity) {
                this.notFull.await();
            }
            this.enqueue(e);
            c = count.getAndIncrement();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        int c = -1;
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            while (count.get() == this.capacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.enqueue(e);
            c = count.getAndIncrement();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int c = -1;
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (count.get() < this.capacity) {
                this.enqueue(e);
                c = count.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        MultiQueueRunnable x = null;
        int c = -1;
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (true) {
                if (count.get() != 0 && this.nodeCount.get() != 0) {
                    E e = this.dequeue();
                    x = (MultiQueueRunnable)e;
                    if (e != null) break;
                }
                this.notEmpty.await();
            }
            x.taked();
            c = count.getAndDecrement();
            if (c > 1 && this.nodeCount.get() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        ReentrantLock lock = this.putLock;
        lock.lock();
        try {
            Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple(x);
            this.putTupleIntoQueue(tuple);
        }
        finally {
            lock.unlock();
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return (E)x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E x = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            x = this.dequeue();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        E x = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                x = this.dequeue();
                c = count.getAndDecrement();
                if (c > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    void unlink(Node<E> p, Node<E> trail) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.fullyLock();
        try {
            Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple((Named)o);
            boolean bl = ((Queue)tuple.right).remove(o);
            return bl;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        int j = maxElements;
        boolean signalNotFull = false;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            for (Tuple<QueueConfig, Queue<E>> tuple : this.manager.getAll()) {
                int count = ((Queue)tuple.right).size();
                if (!((Queue)tuple.right).removeAll(c)) continue;
                i += count;
                if ((j -= count) > 0) continue;
                break;
            }
            int n = i;
            return n;
        }
        finally {
            takeLock.unlock();
            if (signalNotFull) {
                this.signalNotFull();
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Tuple tuple, long start, long finished) {
        ReentrantLock lock = this.putLock;
        lock.lock();
        try {
            ((QueueConfig)tuple.left).decrementAndGet();
            ((QueueConfig)tuple.left).addExecutTime(finished - start, finished);
            this.putTupleIntoQueue(tuple);
        }
        finally {
            lock.unlock();
        }
    }

    public static void main(String[] args) throws Exception {
        int j;
        long start = System.currentTimeMillis();
        final AtomicLong producerCounter = new AtomicLong();
        final AtomicLong consumerCounter = new AtomicLong();
        final Tuple timer = new Tuple((Object)System.currentTimeMillis(), (Object)System.currentTimeMillis());
        final MultiLinkedBlockingQueue wrapper = new MultiLinkedBlockingQueue();
        int maxActive = 10;
        class DefaultQueueConfigManager
        extends DefaultMultiQueueManager {
            final List list = new ArrayList();
            int maxThread;
            private MultiBlockingQueueExecutor executor = null;

            public DefaultQueueConfigManager(int maxThread) {
                this.maxThread = maxThread;
            }

            public void setExecutor(MultiBlockingQueueExecutor executor) {
                this.executor = executor;
            }

            public Tuple<QueueConfig, Queue> newTuple(Named named) {
                Tuple tuple = super.newTuple(named);
                this.list.add(tuple);
                this.adjustMaxActive(tuple);
                return tuple;
            }

            public Queue createQueue(QueueConfig config) {
                return new LinkedBlockingQueue(config.getMaxQueue());
            }

            @Override
            public QueueConfig getConfig(Named named) {
                QueueConfig config = new QueueConfig();
                config.setMaxQueue(1000000);
                config.setName(named.getName());
                return config;
            }

            public int getIdleSize() {
                if (this.executor == null) {
                    return 0;
                }
                return this.maxThread - this.executor.getRunningSize();
            }

            private void adjustMaxActive(Tuple<QueueConfig, Queue> tuple) {
                int maxActive = 0;
                maxActive = ((QueueConfig)tuple.left).getAverageLatencyTime() <= 10L ? (int)(0.9 * (double)this.maxThread) : (((QueueConfig)tuple.left).getAverageLatencyTime() < 100L ? (int)(0.8 * (double)this.maxThread) : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 1000L ? (int)(0.5 * (double)this.maxThread) + this.getIdleSize() : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 5000L ? (int)(0.2 * (double)this.maxThread) + this.getIdleSize() : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 10000L ? (int)(0.1 * (double)this.maxThread + 0.7 * (double)this.getIdleSize()) : (int)(0.05 * (double)this.maxThread + 0.5 * (double)this.getIdleSize())))));
                if (((QueueConfig)tuple.left).getMaxActive() > 0 && (double)this.getIdleSize() <= 0.05 * (double)this.maxThread && (double)((QueueConfig)tuple.left).getRunningSize() >= 0.9 * (double)((QueueConfig)tuple.left).getMaxActive()) {
                    maxActive = (int)((double)maxActive - 0.1 * (double)this.maxThread);
                }
                if (maxActive == 0) {
                    maxActive = 1;
                } else if (maxActive >= this.maxThread && (maxActive = (int)(0.9 * (double)this.maxThread)) == 0) {
                    maxActive = 1;
                }
                ((QueueConfig)tuple.left).setMaxActive(maxActive);
            }

            public void init() {
                new Thread(){
                    {
                        this.setDaemon(true);
                        this.setName("endPoint-Thread-adjust--" + Thread.currentThread().getName());
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public void run() {
                        block2: while (true) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (list.size() < 1) continue;
                            temp = new ArrayList<E>();
                            temp.addAll(list);
                            System.out.println("-----" + Thread.currentThread().getName() + ",total=" + maxThread + ",idle=" + this.getIdleSize() + "----------");
                            totalRunning = false;
                            queue = new PriorityQueue<QueueConfig>(temp.size(), new Comparator<QueueConfig>(){

                                @Override
                                public int compare(QueueConfig o1, QueueConfig o2) {
                                    return (int)(o2.getAverageLatencyTime() - o1.getAverageLatencyTime());
                                }
                            });
                            it = temp.iterator();
                            while (true) {
                                if (it.hasNext()) ** break;
                                continue block2;
                                tuple = (Tuple)it.next();
                                System.out.println("name=" + ((QueueConfig)tuple.left).getName() + ", running=" + ((QueueConfig)tuple.left).getRunningSize() + ", maxThread=" + ((QueueConfig)tuple.left).getMaxActive() + ", latency=" + ((QueueConfig)tuple.left).getAverageLatencyTime() + ", size=" + ((Queue)tuple.right).size() + ",inQueue=" + ((QueueConfig)tuple.left).isInWaiting());
                                if (((QueueConfig)tuple.left).getRunningSize() <= 0 || ((QueueConfig)tuple.left).getAverageLatencyTime() <= 0L) continue;
                                queue.add((QueueConfig)tuple.left);
                            }
                            break;
                        }
                    }
                }.start();
            }
        }
        DefaultQueueConfigManager manager = new DefaultQueueConfigManager(10);
        wrapper.setManager(manager);
        manager.init();
        int i = 0;
        while (i < 10) {
            j = i++;
            new Thread(){
                {
                    this.setName("producer-" + j);
                }

                @Override
                public void run() {
                    for (int count = 0; count < 100000; ++count) {
                        try {
                            wrapper.put(new MultiQueueRunnable(){

                                @Override
                                public void doRun() {
                                }

                                @Override
                                public String getName() {
                                    return "abcde" + j;
                                }
                            });
                            long in = producerCounter.incrementAndGet();
                            if (in % 100000L != 0L) continue;
                            System.out.println("in<--,count=" + in + ",total=" + (System.currentTimeMillis() - (Long)timer.left) + ",size=" + wrapper.size() + ",consumerCounter=" + consumerCounter.get());
                            timer.left = System.currentTimeMillis();
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
        i = 0;
        while (i < 10) {
            j = i++;
            new Thread(){
                {
                    this.setName("consumer-" + j);
                }

                @Override
                public void run() {
                    while (true) {
                        try {
                            Object entry = wrapper.take();
                            long count = consumerCounter.incrementAndGet();
                            ((MultiQueueRunnable)entry).run();
                            if (count % 100000L != 0L) continue;
                            System.out.println("out-->,count=" + count + ",total=" + (System.currentTimeMillis() - (Long)timer.right) + ",size=" + wrapper.size());
                            timer.right = System.currentTimeMillis();
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    static class Node<E> {
        E item;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }
}

