/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.poolable;

import com.meidusa.venus.heartbeat.HeartbeatManager;
import com.meidusa.venus.heartbeat.Status;
import com.meidusa.venus.poolable.ObjectPool;
import com.meidusa.venus.poolable.PoolableObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool.PoolableObjectFactory;

public class MultipleLoadBalanceObjectPool
implements ObjectPool {
    public static final int LOADBALANCING_ROUNDROBIN = 1;
    public static final int LOADBALANCING_WEIGHTBASED = 2;
    public static final int LOADBALANCING_HA = 3;
    private boolean enable;
    private String name;
    private int loadbalance;
    private AtomicLong currentCount = new AtomicLong(0L);
    private ObjectPool[] objectPools;
    private ObjectPool[] runtimeObjectPools;
    private int index = 0;
    private ActiveNumComparator comparator = new ActiveNumComparator();
    private boolean valid;
    MultipleHeartbeatDelayed delayed = new MultipleHeartbeatDelayed(3L, TimeUnit.SECONDS, this);

    public MultipleLoadBalanceObjectPool() {
    }

    public MultipleLoadBalanceObjectPool(int loadbalance, ObjectPool ... objectPools) {
        this.setObjectPools(objectPools);
        this.loadbalance = loadbalance;
    }

    public void setLoadbalance(int loadbalance) {
        this.loadbalance = loadbalance;
    }

    public void setObjectPools(ObjectPool[] objectPools) {
        this.objectPools = objectPools;
        this.runtimeObjectPools = (ObjectPool[])objectPools.clone();
    }

    public void addObject() throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object borrowObject() throws Exception {
        ObjectPool pool = null;
        while (true) {
            ObjectPool[] poolsTemp;
            if ((poolsTemp = this.runtimeObjectPools).length == 0) {
                throw new Exception("poolName=" + this.name + ", no valid pools");
            }
            if (this.loadbalance == 1) {
                long current = this.currentCount.getAndIncrement();
                pool = poolsTemp[(int)(current % (long)poolsTemp.length)];
            } else if (this.loadbalance == 2) {
                if (poolsTemp.length > 1) {
                    ObjectPool[] objectPoolsCloned = (ObjectPool[])poolsTemp.clone();
                    Arrays.sort(objectPoolsCloned, this.comparator);
                    pool = objectPoolsCloned[0];
                } else if (poolsTemp.length == 1) {
                    pool = poolsTemp[0];
                }
            } else if (this.loadbalance == 3) {
                pool = this.index < poolsTemp.length ? poolsTemp[this.index] : poolsTemp[0];
            } else {
                throw new Exception("poolName=" + this.name + " loadbalance parameter error,parameter loadbalance in [1,2,3]");
            }
            if (pool.isValid()) break;
            this.validate();
        }
        return pool.borrowObject();
    }

    public void initAllPools() {
    }

    public void clear() throws Exception, UnsupportedOperationException {
    }

    public int getNumActive() throws UnsupportedOperationException {
        int active = 0;
        for (ObjectPool pool : this.objectPools) {
            active += pool.getNumActive();
        }
        return active;
    }

    public int getNumIdle() throws UnsupportedOperationException {
        int idle = 0;
        for (ObjectPool pool : this.objectPools) {
            idle += pool.getNumIdle();
        }
        return idle;
    }

    public void invalidateObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject)obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.invalidateObject(obj);
    }

    public void returnObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject)obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.returnObject(obj);
    }

    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("setFactory is not supported in class=" + this.getClass().getName());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public void setEnable(boolean isEnabled) {
        this.enable = isEnabled;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void init() {
        HeartbeatManager.addHeartbeat(this.delayed);
    }

    public void close() throws Exception {
        HeartbeatManager.removeHeartbeat(this.delayed);
    }

    @Override
    public boolean validate() {
        ArrayList<ObjectPool> poolList = new ArrayList<ObjectPool>();
        for (ObjectPool object : this.objectPools) {
            if (!object.isValid()) continue;
            poolList.add(object);
        }
        this.runtimeObjectPools = poolList.toArray(new ObjectPool[poolList.size()]);
        ObjectPool[] poolsTemp = this.runtimeObjectPools;
        return poolsTemp.length != 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static class MultipleHeartbeatDelayed
    extends ObjectPool.ObjectPoolHeartbeatDelayed {
        public MultipleHeartbeatDelayed(long nsTime, TimeUnit timeUnit, MultipleLoadBalanceObjectPool pool) {
            super(nsTime, timeUnit, pool);
        }

        @Override
        public boolean isCycle() {
            return true;
        }

        @Override
        public Status doCheck() {
            return super.doCheck();
        }
    }

    protected static class ActiveNumComparator
    implements Comparator<ObjectPool> {
        protected ActiveNumComparator() {
        }

        @Override
        public int compare(ObjectPool o1, ObjectPool o2) {
            return o1.getNumActive() - o2.getNumActive();
        }
    }
}

