package com.meidusa.toolkit.web.page;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;

public class PagingIntercept extends AbstractInterceptor {

	@Override
	public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();

        if (action instanceof Pageable) {
        	Pageable pageable = (Pageable) action;
            ValueStack stack = invocation.getStack();
            if (pageable.getPaging() !=  null) {
            	stack.push(pageable.getPaging());
            }
        }
        return invocation.invoke();
 	}

}
