/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import org.xml.sax.Locator;

public class Location
implements Locator {
    private final String publicId;
    private final String systemId;
    private final int lineNumber;
    private final int columnNumber;
    public static final Location EMPTY_LOCATION = new Location(null, null, -1, -1);

    public Location(Locator locator) {
        this(locator.getPublicId(), locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
    }

    public Location(String publicId, String systemId, int lineNumber, int columnNumber) {
        if (publicId != null && (publicId = publicId.trim()) != null && publicId.length() == 0) {
            publicId = null;
        }
        if (systemId != null && (systemId = systemId.trim()) != null && systemId.length() == 0) {
            systemId = null;
        }
        if (lineNumber <= 0) {
            lineNumber = -1;
        }
        if (columnNumber <= 0) {
            columnNumber = -1;
        }
        this.publicId = publicId;
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        if (this.systemId == null) {
            return "Unknown location";
        }
        StringBuffer buffer = new StringBuffer(this.systemId);
        if (this.lineNumber > 0) {
            buffer.append(':').append(this.lineNumber);
            if (this.columnNumber > 0) {
                buffer.append(':').append(this.columnNumber);
            }
        }
        return buffer.toString();
    }
}

