/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.AbstractConfiguration;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.Configuration;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.ConfigurationException;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultConfiguration
extends AbstractConfiguration
implements Serializable {
    private static final long serialVersionUID = 3545521720271452213L;
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final Location m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(String name) {
        this(name, null, "", "");
    }

    public DefaultConfiguration(String name, Location location) {
        this(name, location, "", "");
    }

    public DefaultConfiguration(String name, Location location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNamespace() throws ConfigurationException {
        if (this.m_namespace != null) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    protected String getPrefix() throws ConfigurationException {
        if (this.m_prefix != null) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public Location getLocation() {
        return this.m_location;
    }

    @Override
    public String getValue(String defaultValue) {
        if (!StringUtil.isEmpty(this.m_value)) {
            return this.m_value;
        }
        return defaultValue;
    }

    @Override
    public String getValue() throws ConfigurationException {
        if (!StringUtil.isEmpty(this.m_value)) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public String[] getAttributeNames() {
        if (this.m_attributes == null) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    @Override
    public Configuration[] getChildren() {
        if (this.m_children == null) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    @Override
    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = this.m_attributes != null ? (String)this.m_attributes.get(name) : null;
        if (!StringUtil.isEmpty(value)) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public Configuration getChild(String name, boolean createNew) {
        if (this.m_children != null) {
            int size = this.m_children.size();
            int i = 0;
            while (i < size) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (name.equals(configuration.getName())) {
                    return configuration;
                }
                ++i;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, Location.EMPTY_LOCATION);
        }
        return null;
    }

    @Override
    public Configuration[] getChildren(String name) {
        if (this.m_children == null) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (name.equals(configuration.getName())) {
                children.add(configuration);
            }
            ++i;
        }
        return children.toArray(new Configuration[0]);
    }

    public void appendValueData(String value) {
        this.checkWriteable();
        this.m_value = this.m_value == null ? value : String.valueOf(this.m_value) + value;
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    public String addAttribute(String name, String value) {
        this.checkWriteable();
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void addAll(Configuration other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(Configuration other) {
        this.checkWriteable();
        String[] attributes = other.getAttributeNames();
        int i = 0;
        while (i < attributes.length) {
            String name = attributes[i];
            String value = other.getAttribute(name, null);
            this.setAttribute(name, value);
            ++i;
        }
    }

    public void addAllChildren(Configuration other) {
        this.checkWriteable();
        Configuration[] children = other.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addChild(children[i]);
            ++i;
        }
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (this.m_children == null) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }
}

