/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.common.util.regex.PathNameCompiler;
import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntryFactory;
import com.meidusa.toolkit.plugins.autoconfig.entry.DirectoryConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.entry.ZipConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.util.NumberUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.PatternSet;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import java.io.File;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class ConfigEntryFactoryImpl
implements ConfigEntryFactory {
    private ConfigSettings settings;

    public ConfigEntryFactoryImpl(ConfigSettings settings) {
        this.settings = settings;
    }

    @Override
    public ConfigEntry create(ConfigResource resource) {
        File file = resource.getFile();
        String name = resource.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (file != null && !file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        if (name.endsWith(".war")) {
            return this.createWarEntry(resource);
        }
        if (name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".rar")) {
            return this.createGenericJarEntry(resource);
        }
        if (file != null && file.isDirectory()) {
            return this.createGenericDirectoryEntry(resource);
        }
        return this.createGenericJarEntry(resource);
    }

    protected void populateCommonContext(Map context) {
        context.put("stringUtil", new StringUtil());
        context.put("numberUtil", new NumberUtil());
    }

    protected void populateWarContext(Map context, String name) {
        Pattern componentNamePattern;
        Perl5Matcher matcher = new Perl5Matcher();
        String componentName = "";
        try {
            componentNamePattern = new PathNameCompiler().compile("META-INF/**/autoconf/auto-config.xml");
        }
        catch (MalformedPatternException e) {
            throw new ConfigException(e);
        }
        if (matcher.matches(name.replace('\\', '/'), componentNamePattern)) {
            componentName = matcher.getMatch().group(1);
        }
        context.put("component", componentName);
    }

    private ConfigEntry createWarEntry(ConfigResource resource) {
        File file = resource.getFile();
        ConfigEntry entry = file != null && file.isDirectory() ? new DirectoryConfigEntry(resource, this.settings){

            @Override
            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
                ConfigEntryFactoryImpl.this.populateWarContext(context, name);
            }
        } : new ZipConfigEntry(resource, this.settings){

            @Override
            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
                ConfigEntryFactoryImpl.this.populateWarContext(context, name);
            }
        };
        entry.setDescriptorPatterns(new PatternSet("META-INF/**/auto-config.xml"));
        entry.setPackagePatterns(new PatternSet("WEB-INF/lib/*.jar"));
        return entry;
    }

    private ConfigEntry createGenericJarEntry(ConfigResource resource) {
        File file = resource.getFile();
        ConfigEntry entry = file != null && file.isDirectory() ? new DirectoryConfigEntry(resource, this.settings){

            @Override
            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        } : new ZipConfigEntry(resource, this.settings){

            @Override
            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        };
        entry.setDescriptorPatterns(new PatternSet("META-INF/**/auto-config.xml"));
        entry.setPackagePatterns(new PatternSet("**/*.jar, **/*.war, **/*.rar, **/*.ear"));
        return entry;
    }

    private ConfigEntry createGenericDirectoryEntry(ConfigResource resource) {
        DirectoryConfigEntry entry = new DirectoryConfigEntry(resource, this.settings){

            @Override
            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        };
        entry.setDescriptorPatterns(new PatternSet(this.settings.getDescriptorPatterns(), new PatternSet("conf/**/auto-config.xml, META-INF/**/auto-config.xml")).addDefaultExcludes());
        entry.setPackagePatterns(new PatternSet(this.settings.getPackagePatterns(), new PatternSet(null, "**")).addDefaultExcludes());
        return entry;
    }
}

