/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntryFactory;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGenerator;
import com.meidusa.toolkit.plugins.autoconfig.util.PatternSet;
import com.meidusa.toolkit.plugins.autoconfig.util.SelectorUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.DefaultScannerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ConfigEntry {
    private ConfigSettings settings;
    private ConfigResource resource;
    private PatternSet descriptorPatterns;
    private PatternSet packagePatterns;
    protected ConfigEntry[] subEntries;
    private final ConfigGenerator generator;

    public ConfigEntry(ConfigResource resource, ConfigSettings settings) {
        this.resource = resource;
        this.settings = settings;
        this.generator = new ConfigGenerator(settings);
    }

    public String getName() {
        return this.getConfigEntryResource().getName();
    }

    public boolean isEmpty() {
        return this.getSubEntries().length == 0 && this.getGenerator().getConfigDescriptors().length == 0;
    }

    public ConfigResource getConfigEntryResource() {
        return this.resource;
    }

    public ConfigSettings getConfigSettings() {
        return this.settings;
    }

    public PatternSet getDescriptorPatterns() {
        return this.descriptorPatterns;
    }

    public void setDescriptorPatterns(PatternSet descriptorPatterns) {
        this.descriptorPatterns = descriptorPatterns;
    }

    public PatternSet getPackagePatterns() {
        return this.packagePatterns;
    }

    public void setPackagePatterns(PatternSet packagePatterns) {
        this.packagePatterns = packagePatterns;
    }

    public ConfigGenerator getGenerator() {
        return this.generator;
    }

    public ConfigEntry[] getSubEntries() {
        return this.subEntries;
    }

    public void scan() {
        this.scan(null);
    }

    protected abstract void scan(InputStream var1);

    protected void populateDescriptorContext(Map context, String string) {
    }

    public void generate() {
        this.generate(null, null);
    }

    protected abstract void generate(InputStream var1, OutputStream var2);

    public class Handler
    extends DefaultScannerHandler {
        private List subEntries = new ArrayList();

        public ConfigEntry[] getSubEntries() {
            return this.subEntries.toArray(new ConfigEntry[this.subEntries.size()]);
        }

        @Override
        public void startScanning() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Scanning ").append(this.getScanner().getBaseURL()).append("\n");
            buffer.append("  descriptors: ").append(ConfigEntry.this.getDescriptorPatterns()).append("\n");
            buffer.append("     packages: ").append(ConfigEntry.this.getPackagePatterns()).append("\n");
            ConfigEntry.this.settings.debug(buffer.toString());
        }

        @Override
        public void file() {
            String name = this.getScanner().getPath();
            if (this.isDescriptorFile(name)) {
                ConfigEntry.this.settings.debug("Loading descriptor " + this.getScanner().getURL() + "\n");
                this.loadDescriptor();
            } else if (this.isPackageFile(name)) {
                ConfigResource resource = new ConfigResource(this.getScanner().getURL(), name);
                ConfigEntryFactory factory = ConfigEntry.this.getConfigSettings().getConfigEntryFactory();
                ConfigEntry subEntry = factory.create(resource);
                InputStream istream = null;
                try {
                    istream = this.getScanner().getInputStream();
                    subEntry.scan(istream);
                }
                finally {
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!subEntry.isEmpty()) {
                    this.subEntries.add(subEntry);
                }
            }
        }

        @Override
        public void directory() {
            String name = this.getScanner().getPath();
            if (this.isPackageFile(name)) {
                ConfigResource resource = new ConfigResource(this.getScanner().getURL(), name);
                ConfigEntryFactory factory = ConfigEntry.this.getConfigSettings().getConfigEntryFactory();
                ConfigEntry subEntry = factory.create(resource);
                subEntry.scan();
                if (!subEntry.isEmpty()) {
                    this.subEntries.add(subEntry);
                }
            }
        }

        @Override
        public boolean followUp() {
            String name = this.getScanner().getPath();
            boolean followUp = false;
            followUp |= SelectorUtil.matchPathPrefix(name, ConfigEntry.this.getDescriptorPatterns().getIncludes(), ConfigEntry.this.getDescriptorPatterns().getExcludes());
            followUp |= SelectorUtil.matchPathPrefix(name, ConfigEntry.this.getPackagePatterns().getIncludes(), ConfigEntry.this.getPackagePatterns().getExcludes());
            if (this.isPackageFile(name)) {
                return false;
            }
            if (!followUp) {
                ConfigEntry.this.getConfigSettings().debug("Skipping directory " + name);
            }
            return followUp;
        }

        private void loadDescriptor() {
            ConfigDescriptor descriptor;
            URL descriptorURL = this.getScanner().getURL();
            ConfigResource descriptorResource = new ConfigResource(descriptorURL, this.getScanner().getPath());
            InputStream istream = null;
            try {
                istream = this.getScanner().getInputStream();
                descriptor = ConfigEntry.this.getGenerator().addConfigDescriptor(descriptorResource, istream);
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ConfigEntry.this.populateDescriptorContext(descriptor.getContext(), descriptor.getName());
        }

        private boolean isDescriptorFile(String name) {
            return SelectorUtil.matchPath(name, ConfigEntry.this.getDescriptorPatterns().getIncludes(), ConfigEntry.this.getDescriptorPatterns().getExcludes());
        }

        private boolean isPackageFile(String name) {
            return SelectorUtil.matchPath(name, ConfigEntry.this.getPackagePatterns().getIncludes(), ConfigEntry.this.getPackagePatterns().getExcludes());
        }
    }
}

