/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidatorException;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RegexpValidator
extends ConfigValidator {
    private static final Logger log = Logger.getLogger(RegexpValidator.class);
    private String regexp;
    private String mode;

    @Override
    public Logger getLogger() {
        return log;
    }

    protected String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    protected String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public boolean validate(String value) {
        if (StringUtil.isEmpty(this.getRegexp())) {
            throw new ConfigValidatorException("You must define an attribute called 'regexp' for regexp validator");
        }
        if (StringUtil.isEmpty(this.getMode())) {
            this.setMode("contain");
        }
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Validating value with regexp[" + this.getRegexp() + "]: " + value));
        }
        Pattern pattern = null;
        try {
            pattern = new Perl5Compiler().compile(this.getRegexp(), 32784);
        }
        catch (MalformedPatternException e) {
            throw new ConfigValidatorException(e);
        }
        if (!(this.getMode().endsWith("contain") || this.getMode().endsWith("exact") || this.getMode().endsWith("prefix"))) {
            throw new ConfigValidatorException("Invalid regexp mode: " + this.getMode() + ", should be contain, exact or prefix.");
        }
        Perl5Matcher matcher = new Perl5Matcher();
        boolean not = this.getMode().startsWith("!");
        if (this.getMode().endsWith("contain")) {
            boolean match = matcher.contains(value, pattern);
            return not ? !match : match;
        }
        if (this.getMode().endsWith("exact")) {
            boolean match = matcher.matches(value, pattern);
            return not ? !match : match;
        }
        if (this.getMode().endsWith("prefix")) {
            boolean match = matcher.matchesPrefix(value, pattern);
            return not ? !match : match;
        }
        return false;
    }

    @Override
    protected String getDefaultMessage() {
        return "\u53c2\u6570\u503c\u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f\uff1a" + this.getRegexp();
    }
}

