/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.cli;

import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntime;
import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntimeImpl;
import com.meidusa.toolkit.plugins.autoconfig.cli.CLIException;
import com.meidusa.toolkit.plugins.autoconfig.cli.CLIManager;
import com.meidusa.toolkit.plugins.autoconfig.util.Profiler;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.CommandLine;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.log4j.xml.DOMConfigurator;

public class Main {
    private static CommandLine cli;
    private static ConfigRuntime runtime;

    public static void main(String[] args) {
        int returnCode;
        block5: {
            Profiler.start("maven auto config plugin starting....");
            Main.initLogging("quiet");
            returnCode = 0;
            try {
                try {
                    returnCode = Main.run(args);
                }
                catch (CLIException e) {
                    System.err.println(e.getMessage());
                    System.exit(returnCode);
                    Profiler.release();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Profiler.release();
                throw throwable;
            }
            Profiler.release();
        }
        runtime.info("");
        runtime.info(Main.getDuration("\u603b\u8017\u8d39\u65f6\u95f4\uff1a{0,choice,0#|.1#{0,number,integer}\u5206}{1,choice,0#|.1#{1,number,integer}\u79d2}{2,number,integer}\u6beb\u79d2", Profiler.getEntry().getDuration()));
        runtime.info("");
        System.exit(returnCode);
    }

    private static String getDuration(String message, long duration) {
        long ms = duration % 1000L;
        long secs = duration / 1000L % 60L;
        long min = duration / 1000L / 60L;
        return MessageFormat.format(message, new Long(min), new Long(secs), new Long(ms));
    }

    private static void initLogging(String name) {
        DOMConfigurator.configure((URL)Main.class.getResource("log4j-" + name + ".xml"));
    }

    private static int run(String[] args) {
        CLIManager manager = new CLIManager();
        if (args.length == 0) {
            args = new String[]{"-h"};
        }
        cli = manager.parse(args);
        String charset = cli.getOptionValue("config.c");
        ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in, System.out, System.err, charset);
        runtime = runtimeImpl;
        if (cli.hasOption("config.h")) {
            manager.help(runtimeImpl.getOut());
            return 0;
        }
        if (cli.hasOption("config.g")) {
            runtimeImpl.setGuiMode();
        }
        if (cli.hasOption("config.t")) {
            runtimeImpl.setTextMode();
        }
        if (cli.hasOption("config.I")) {
            runtimeImpl.setInteractiveMode("off");
        } else if (cli.hasOption("config.i")) {
            String mode = cli.getOptionValue("config.i");
            if (StringUtil.isBlank(mode)) {
                runtimeImpl.setInteractiveMode("on");
            } else {
                runtimeImpl.setInteractiveMode(mode);
            }
        }
        runtimeImpl.setDescriptorPatterns(cli.getOptionValue("config.d"), cli.getOptionValue("config.D"));
        runtimeImpl.setPackagePatterns(cli.getOptionValue("config.p"), cli.getOptionValue("config.P"));
        runtimeImpl.setDests(cli.getArgs());
        if (cli.hasOption("config.u")) {
            runtimeImpl.setUserPropertiesFile(cli.getOptionValue("config.u"), charset);
        }
        if (cli.hasOption("config.v")) {
            runtimeImpl.setVerbose();
            Main.initLogging("verbose");
        }
        try {
            runtimeImpl.start();
        }
        catch (Exception e) {
            runtimeImpl.error(e);
        }
        return 0;
    }
}

