package com.meidusa.toolkit.plugins.autoconfig.util.scanner;

import com.meidusa.toolkit.plugins.autoconfig.util.ZipUtil;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

import java.net.MalformedURLException;
import java.net.URL;

import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * Zipļɨ
 *
 * 
 */
public class ZipScanner extends AbstractScanner {
    private URL            zipURL;
    private ZipInputStream zis;
    private ZipEntry       zipEntry;

/**
     * һzipļɨ
     *
     * @param zipfile zipļ
     * @param handler ص
     */
    public ZipScanner(File zipfile, ScannerHandler handler) {
        super(handler);

        if (!zipfile.exists() || !zipfile.isFile() || !zipfile.canRead()) {
            throw new IllegalArgumentException(zipfile + " is not a readable file");
        }

        try {
            this.zipURL = zipfile.toURL();
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(zipfile + " is not a readable file");
        }
    }

/**
     * һzipļɨ
     *
     * @param zipURL zipļURL
     * @param handler ص
     */
    public ZipScanner(URL zipURL, ScannerHandler handler) {
        super(handler);

        this.zipURL = zipURL;
    }

    /**
     * ȡɨzipļURL
     *
     * @return ɨzipļURL
     */
    public URL getBaseURL() {
        return zipURL;
    }

    /**
     * ȡõǰɨļURL
     *
     * @return URL
     */
    public URL getURL() {
        try {
            return ZipUtil.getJarURL(getBaseURL(), getPath());
        } catch (MalformedURLException e) {
            throw new ScannerException(e);
        }
    }

    /**
     * ȡõǰɨļ
     *
     * @return 
     */
    public InputStream getInputStream() {
        return new FilterInputStream(zis) {
                public void close() throws IOException {
                    // ر
                }
            };
    }

    /**
     * zipļ
     *
     * @param istream zipļ
     */
    public void setInputStream(InputStream istream) {
        if (istream != null) {
            this.zis = new ZipInputStream(istream);
        }
    }

    /**
     * ȡõǰڴzip entry
     *
     * @return zip entry
     */
    public ZipEntry getZipEntry() {
        return zipEntry;
    }

    /**
     * ִɨ衣
     */
    public void scan() {
        getScannerHandler().setScanner(this);
        getScannerHandler().startScanning();

        boolean needClose = false;

        if (zis == null) {
            try {
                zis       = new ZipInputStream(getBaseURL().openStream());
                needClose = true;
            } catch (IOException e) {
                throw new ScannerException(e);
            }
        }

        try {
            doScan();
        } finally {
            if (needClose) {
                try {
                    zis.close();
                } catch (IOException e) {
                }
            }
        }

        getScannerHandler().endScanning();
    }

    /**
     * ִɨ衣
     */
    protected void doScan() {
        try {
            while ((zipEntry = zis.getNextEntry()) != null) {
                String savedPath = setPath(zipEntry.getName());

                if (zipEntry.isDirectory()) {
                    getScannerHandler().directory();
                } else {
                    getScannerHandler().file();
                }

                setPath(savedPath);
            }
        } catch (IOException e) {
            System.err.println("WARING! Failed to get ZipEntry");
            e.printStackTrace();
        }
    }
}
