package com.meidusa.toolkit.plugins.autoconfig.util.scanner;

import com.meidusa.toolkit.plugins.autoconfig.util.FileUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import java.net.MalformedURLException;
import java.net.URL;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * ļɨ
 *
 * 
 */
public class DirectoryScanner extends AbstractScanner {
    private File    basedir;
    private URL     baseURL;
    private boolean followSymlinks = true;

/**
     * һļĿ¼ɨ
     *
     * @param basedir ļĿ¼
     * @param handler ص
     */
    public DirectoryScanner(File basedir, ScannerHandler handler) {
        super(handler);

        if (!basedir.exists() || !basedir.isDirectory()) {
            throw new IllegalArgumentException(basedir + " is not a directory");
        }

        try {
            this.baseURL = basedir.toURL();
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(basedir + " is not a directory");
        }

        this.basedir = basedir;
    }

    /**
     * ȡɨĸĿ¼
     *
     * @return ɨĸĿ¼
     */
    public File getBasedir() {
        return basedir;
    }

    /**
     * ȡɨĸĿ¼URL
     *
     * @return ɨĸĿ¼URL
     */
    public URL getBaseURL() {
        return baseURL;
    }

    /**
     * ȡõǰɨļURL
     *
     * @return URL
     */
    public URL getURL() {
        try {
            return new File(getBasedir(), getPath()).toURL();
        } catch (MalformedURLException e) {
            throw new ScannerException(e);
        }
    }

    /**
     * ȡõǰɨļ
     *
     * @return 
     */
    public InputStream getInputStream() {
        try {
            return new FileInputStream(new File(getBasedir(), getPath()));
        } catch (FileNotFoundException e) {
            throw new ScannerException(e);
        }
    }

    /**
     * Ƿɨӡ
     *
     * @return ǣ򷵻<code>true</code>
     */
    public boolean isFollowSymlinks() {
        return followSymlinks;
    }

    /**
     * Ƿɨӡ
     *
     * @param followSymlinks Ƿɨ
     */
    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    /**
     * ִɨ衣
     */
    public void scan() {
        Set processed = new HashSet();

        getScannerHandler().setScanner(this);

        getScannerHandler().startScanning();

        scandir(getBasedir(), processed);

        getScannerHandler().endScanning();
    }

    /**
     * ɨָĿ¼
     *
     * @param dir ɨĿ¼
     * @param processed ѱɨľ·ֹΪӴµظɨ
     */
    protected void scandir(File dir, Set processed) {
        // ֹѭ
        try {
            String canonicalPath = dir.getCanonicalPath();

            if (processed.contains(canonicalPath)) {
                return;
            }

            processed.add(canonicalPath);
        } catch (IOException e) {
            throw new ScannerException(e);
        }

        // гǰĿ¼µļ
        String[] files = dir.list();

        if (files == null) {
            throw new ScannerException("IO error scanning directory " + dir.getAbsolutePath());
        }

        // ųӣҪĻ
        if (!followSymlinks) {
            List noLinks = new ArrayList(files.length);

            for (int i = 0; i < files.length; i++) {
                try {
                    if (!FileUtil.isSymbolicLink(dir, files[i])) {
                        noLinks.add(files[i]);
                    }
                } catch (IOException e) {
                    System.err.println("IOException caught while checking for links, couldn't get cannonical path!");
                    noLinks.add(files[i]);
                }
            }

            files = (String[]) noLinks.toArray(new String[noLinks.size()]);
        }

        // ݹɨļĿ¼
        for (int i = 0; i < files.length; i++) {
            String name      = getPath() + files[i];
            File   file      = new File(dir, files[i]);
            String savedPath;

            if (file.isDirectory()) {
                savedPath    = setPath(name + '/');

                getScannerHandler().directory();

                if (getScannerHandler().followUp()) {
                    scandir(file, processed);
                }
            } else {
                savedPath = setPath(name);

                getScannerHandler().file();
            }

            setPath(savedPath);
        }
    }
}
