package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorSession;
import com.meidusa.toolkit.plugins.autoconfig.generator.DirectoryCallback;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.DirectoryScanner;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.Scanner;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * һĿ¼͵Ϣ
 *
 * 
 */
public class DirectoryConfigEntry extends ConfigEntry {
/**
     * һ㡣
     *
     * @param resource ָԴ
     * @param settings autoconfig
     */
    public DirectoryConfigEntry(ConfigResource resource, ConfigSettings settings) {
        super(resource, settings);
    }

    /**
     * ɨ㡣
     */
    protected void scan(InputStream istream) {
        Handler handler = new Handler();
        Scanner scanner = new DirectoryScanner(getConfigEntryResource().getFile(), handler);

        try {
            scanner.scan();
        } catch (ScannerException e) {
            throw new ConfigException(e);
        }

        subEntries = handler.getSubEntries();

        getGenerator().init();
    }

    /**
     * ļ
     */
    protected void generate(InputStream istream, OutputStream ostream) {
        getConfigSettings().debug("Processing files in " + getConfigEntryResource().getURL());

        // Լdescriptors
        try {
            File   propsFile        = getConfigSettings().getUserPropertiesFile();
            String propsFileCharset = getConfigSettings().getUserPropertiesFileCharset();

            ConfigGeneratorSession session = getGenerator().startSession(propsFile, propsFileCharset);

            session.generate(new DirectoryCallback(getGenerator()));
        } finally {
            getGenerator().closeSession();
        }

        // entries
        ConfigEntry[] subEntries = getSubEntries();

        for (int i = 0; i < subEntries.length; i++) {
            ConfigEntry subEntry = subEntries[i];

            subEntry.generate(null, null);
        }
    }

    /**
     * תַ
     *
     * @return ַʾ
     */
    public String toString() {
        return "DirectoryConfigEntry[" + getConfigEntryResource() + "]";
    }
}
