package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;


import java.io.File;

import org.apache.log4j.Logger;

public class FileExistValidator extends ConfigValidator {
    private static final Logger log      = Logger.getLogger(FileExistValidator.class);
    private String              filename;
    private File                file;

    public Logger getLogger() {
        return log;
    }

    public void setFile(String filename) {
        this.filename                    = filename;
    }

    public boolean validate(String value) {
        if (value == null) {
            return true;
        }

        value = value.trim();

        if (StringUtil.isEmpty(value)) {
            return true;
        }

        if (getLogger().isDebugEnabled()) {
            getLogger().debug("Validating file or directory: " + value);
        }

        if (filename == null) {
            file = new File(value);
        } else {
            file = new File(value, filename);
        }

        return file.isAbsolute() && file.exists();
    }

    protected String getDefaultMessage() {
        return "ļĿ¼ڣǾ·" + file;
    }
}
