package com.meidusa.toolkit.plugins.autoconfig.cli;

import com.meidusa.toolkit.plugins.autoconfig.ConfigConstant;
import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntime;
import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntimeImpl;
import com.meidusa.toolkit.plugins.autoconfig.util.Profiler;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.CommandLine;

import org.apache.log4j.xml.DOMConfigurator;

import java.text.MessageFormat;

/**
 * autoconfig
 *
 * 
 */
public class Main {
    private static CommandLine   cli;
    private static ConfigRuntime runtime;

    public static void main(String[] args) {
        // ʼʱ
        Profiler.start("maven auto config plugin starting....");

        // ʼ־
        initLogging("quiet");

        // ִ
        int returnCode = 0;

        try {
            returnCode = run(args);
        } catch (CLIException e) {
            System.err.println(e.getMessage());
            System.exit(returnCode);
        } finally {
            Profiler.release();
        }

        // ʾʱ
        runtime.info("");
        runtime.info(getDuration("ܺķʱ䣺{0,choice,0#|.1#{0,number,integer}}{1,choice,0#|.1#{1,number,integer}}{2,number,integer}",
                                 Profiler.getEntry().getDuration()));
        runtime.info("");

        // ֵ
        System.exit(returnCode);
    }

    private static String getDuration(String message, long duration) {
        long ms   = duration % 1000;
        long secs = (duration / 1000) % 60;
        long min  = duration / 1000 / 60;

        return MessageFormat.format(message,
                                    new Object[] { new Long(min), new Long(secs), new Long(ms) });
    }

    private static void initLogging(String name) {
        DOMConfigurator.configure(Main.class.getResource("log4j-" + name + ".xml"));
    }

    private static int run(String[] args) {
        CLIManager manager = new CLIManager();

        if (args.length == 0) {
            args = new String[] { "-h" };
        }

        cli = manager.parse(args);

        String            charset     = cli.getOptionValue(CLIManager.OPT_CHARSET);
        ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in, System.out, System.err,
                                                              charset);

        runtime = runtimeImpl;

        // ʾ
        if (cli.hasOption(CLIManager.OPT_HELP)) {
            manager.help(runtimeImpl.getOut());
            return 0;
        }

        // cliݣruntimeԡ
        if (cli.hasOption(CLIManager.OPT_GUI_MODE)) {
            runtimeImpl.setGuiMode();
        }

        if (cli.hasOption(CLIManager.OPT_TEXT_MODE)) {
            runtimeImpl.setTextMode();
        }

        if (cli.hasOption(CLIManager.OPT_NON_INTERACTIVE_MODE)) {
            runtimeImpl.setInteractiveMode(ConfigConstant.INTERACTIVE_OFF);
        } else if (cli.hasOption(CLIManager.OPT_INTERACTIVE_MODE)) {
            String mode = cli.getOptionValue(CLIManager.OPT_INTERACTIVE_MODE);

            if (StringUtil.isBlank(mode)) {
                runtimeImpl.setInteractiveMode(ConfigConstant.INTERACTIVE_ON);
            } else {
                runtimeImpl.setInteractiveMode(mode);
            }
        }

        runtimeImpl.setDescriptorPatterns(cli.getOptionValue(CLIManager.OPT_INCLUDE_DESCRIPTORS),
                                          cli.getOptionValue(CLIManager.OPT_EXCLUDE_DESCRIPTORS));
        runtimeImpl.setPackagePatterns(cli.getOptionValue(CLIManager.OPT_INCLUDE_PACKAGES),
                                       cli.getOptionValue(CLIManager.OPT_EXCLUDE_PACKAGES));

        runtimeImpl.setDests(cli.getArgs());

        if (cli.hasOption(CLIManager.OPT_USER_PROPERTIES)) {
            runtimeImpl.setUserPropertiesFile(cli.getOptionValue(CLIManager.OPT_USER_PROPERTIES),
                                              charset);
        }

        if (cli.hasOption(CLIManager.OPT_VERBOSE)) {
            runtimeImpl.setVerbose();
            initLogging("verbose");
        }

        // autoconfig
        try {
            runtimeImpl.start();
        } catch (Exception e) {
            runtimeImpl.error(e);
        }

        return 0;
    }
}
