/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import com.meidusa.toolkit.plugins.autoconfig.util.configuration.Configuration;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.DefaultConfiguration;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.Location;
import com.meidusa.toolkit.plugins.autoconfig.util.configuration.SAXConfigurationHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespacedSAXConfigurationHandler
extends SAXConfigurationHandler {
    private static final int EXPECTED_DEPTH = 5;
    private final ArrayList m_elements = new ArrayList(5);
    private final ArrayList m_prefixes = new ArrayList(5);
    private final ArrayList m_values = new ArrayList(5);
    private final BitSet m_preserveSpace = new BitSet();
    private Configuration m_configuration;
    private Locator m_locator;
    private NamespaceSupport m_namespaceSupport = new NamespaceSupport();

    @Override
    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public void clear() {
        this.m_elements.clear();
        Iterator i = this.m_prefixes.iterator();
        while (i.hasNext()) {
            ((ArrayList)i.next()).clear();
        }
        this.m_prefixes.clear();
        this.m_values.clear();
        this.m_locator = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_namespaceSupport.reset();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.m_namespaceSupport.reset();
    }

    @Override
    public void characters(char[] ch, int start, int end) throws SAXException {
        int depth = this.m_values.size() - 1;
        StringBuffer valueBuffer = (StringBuffer)this.m_values.get(depth);
        valueBuffer.append(ch, start, end);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        int depth = this.m_elements.size() - 1;
        DefaultConfiguration finishedConfiguration = (DefaultConfiguration)this.m_elements.remove(depth);
        String accumulatedValue = ((StringBuffer)this.m_values.remove(depth)).toString();
        ArrayList prefixes = (ArrayList)this.m_prefixes.remove(depth);
        Iterator i = prefixes.iterator();
        while (i.hasNext()) {
            this.endPrefixMapping((String)i.next());
        }
        prefixes.clear();
        if (finishedConfiguration.getChildren().length == 0) {
            Object finishedValue = this.m_preserveSpace.get(depth) ? accumulatedValue : (accumulatedValue.length() == 0 ? null : accumulatedValue.trim());
            finishedConfiguration.setValue((String)finishedValue);
        } else {
            String trimmedValue = accumulatedValue.trim();
            if (trimmedValue.length() > 0) {
                throw new SAXException("Not allowed to define mixed content in the element " + finishedConfiguration.getName() + " at " + finishedConfiguration.getLocation());
            }
        }
        if (depth == 0) {
            this.m_configuration = finishedConfiguration;
        }
        this.m_namespaceSupport.popContext();
    }

    protected DefaultConfiguration createConfiguration(String localName, String namespaceURI, Location location) {
        String prefix = this.m_namespaceSupport.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = "";
        }
        return new DefaultConfiguration(localName, location, namespaceURI, prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        this.m_namespaceSupport.pushContext();
        DefaultConfiguration configuration = this.createConfiguration(localName, namespaceURI, this.getLocation());
        int depth = this.m_elements.size();
        boolean preserveSpace = false;
        if (depth > 0) {
            DefaultConfiguration parent = (DefaultConfiguration)this.m_elements.get(depth - 1);
            parent.addChild(configuration);
            preserveSpace = this.m_preserveSpace.get(depth - 1);
        }
        this.m_elements.add(configuration);
        this.m_values.add(new StringBuffer());
        ArrayList<String> prefixes = new ArrayList<String>();
        AttributesImpl componentAttr = new AttributesImpl();
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getQName(i).startsWith("xmlns")) {
                prefixes.add(attributes.getLocalName(i));
                this.startPrefixMapping(attributes.getLocalName(i), attributes.getValue(i));
            } else if (attributes.getQName(i).equals("xml:space")) {
                preserveSpace = attributes.getValue(i).equals("preserve");
            } else {
                componentAttr.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
            }
            ++i;
        }
        if (preserveSpace) {
            this.m_preserveSpace.set(depth);
        } else {
            this.m_preserveSpace.clear(depth);
        }
        this.m_prefixes.add(prefixes);
        int attributesSize = componentAttr.getLength();
        int i2 = 0;
        while (i2 < attributesSize) {
            String name = componentAttr.getQName(i2);
            String value = componentAttr.getValue(i2);
            configuration.setAttribute(name, value == null ? null : value.trim());
            ++i2;
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_namespaceSupport.declarePrefix(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }
}

