/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator.expr;

import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;

public class ReferenceExpression
implements Expression {
    private String ref;

    public ReferenceExpression(String ref) {
        this.ref = ref;
    }

    @Override
    public String getExpressionText() {
        return "${" + this.ref + "}";
    }

    @Override
    public Object evaluate(final ExpressionContext context) {
        if (StringUtil.isBlank(this.ref)) {
            return null;
        }
        Object value = context.get(this.ref);
        if (value == null) {
            return null;
        }
        if (value instanceof Expression) {
            return ((Expression)value).evaluate(new ExpressionContext(){

                @Override
                public Object get(String key) {
                    if (ReferenceExpression.this.ref.equals(key) || StringUtil.getValidIdentifier(ReferenceExpression.this.ref).equals(StringUtil.getValidIdentifier(key))) {
                        return null;
                    }
                    return context.get(key);
                }

                @Override
                public void put(String key, Object value) {
                    context.put(key, value);
                }
            });
        }
        return value;
    }

    public String toString() {
        return this.getExpressionText();
    }
}

