/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.GenericHeartbeatDelayed;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBackendConnectionPool<F extends BackendConnectionFactory, V extends BackendConnection>
implements BackendConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBackendConnectionPool.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final F factory;
    private final int size;
    private final BackendConnection[] items;
    private int activeCount;
    private int idleCount;
    private String name;
    private boolean valid = true;
    private boolean closed = false;
    private GenericHeartbeatDelayed delay = new GenericHeartbeatDelayed(3L, TimeUnit.SECONDS, this);

    @Override
    public String getName() {
        return this.name;
    }

    public SimpleBackendConnectionPool(String name, F factory, int size) {
        this.size = size;
        this.items = new BackendConnection[size];
        this.factory = factory;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackendConnection borrowObject() throws Exception {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.activeCount >= this.size) {
                StringBuilder s = new StringBuilder();
                s.append("[name=").append(this.name).append(",active=");
                s.append(this.activeCount).append(",size=").append(this.size).append(']');
                LOGGER.error(s.toString());
            }
            BackendConnection[] items = this.items;
            int len = items.length;
            for (int i = 0; this.idleCount > 0 && i < len; ++i) {
                if (items[i] == null) continue;
                BackendConnection conn = items[i];
                items[i] = null;
                --this.idleCount;
                if (conn.isClosed()) continue;
                ++this.activeCount;
                conn.setActive(true);
                BackendConnection backendConnection = conn;
                return backendConnection;
            }
            ++this.activeCount;
        }
        finally {
            lock.unlock();
        }
        try {
            BackendConnection conn = ((BackendConnectionFactory)this.factory).make();
            conn.setPool(this);
            conn.setActive(true);
            return conn;
        }
        catch (Exception e) {
            lock.lock();
            try {
                --this.activeCount;
            }
            finally {
                lock.unlock();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(BackendConnection c) {
        if (c == null || c.isClosed()) {
            return;
        }
        if (c instanceof AuthingableBackendConnection && !((AuthingableBackendConnection)c).isAuthenticated()) {
            return;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BackendConnection[] items = this.items;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] != null) continue;
                ++this.idleCount;
                --this.activeCount;
                items[i] = c;
                c.setActive(false);
                return;
            }
        }
        finally {
            lock.unlock();
        }
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.delay);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int len = this.items.length;
            for (int i = 0; this.idleCount > 0 && i < len; ++i) {
                if (this.items[i] == null) continue;
                BackendConnection conn = this.items[i];
                this.items[i] = null;
                --this.idleCount;
                if (conn.isClosed()) continue;
                conn.close();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActive() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.activeCount;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deActive(BackendConnection c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            --this.activeCount;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean b) {
        this.valid = b;
    }

    @Override
    public void init() {
        HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.delay);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

