/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.common.poolable.HashFunction;
import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleLoadBalanceBackendConnectionPool
implements BackendConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(MultipleLoadBalanceBackendConnectionPool.class);
    static int HashMod = Integer.valueOf(System.getProperty("venus.HashFunction.mod", "1024"));
    static HashFunction function = new DefaultFunction();
    public static final int LOADBALANCING_ROUNDROBIN = 1;
    public static final int LOADBALANCING_WEIGHTBASED = 2;
    public static final int LOADBALANCING_HA = 3;
    public static final int LOADBALANCING_HASH = 4;
    private boolean enable;
    private final String name;
    private boolean closed = false;
    private int loadbalance;
    private volatile long currentCount = 0L;
    private BackendConnectionPool[] objectPools;
    private BackendConnectionPool[] runtimeObjectPools;
    private int index = 0;
    private ActiveNumComparator comparator = new ActiveNumComparator();
    private boolean valid;
    private SortedMap<Integer, BackendConnectionPool> circle = new TreeMap<Integer, BackendConnectionPool>();
    MultipleHeartbeatDelayed delayed;

    public MultipleLoadBalanceBackendConnectionPool(String name, int loadbalance, BackendConnectionPool ... objectPools) {
        this.loadbalance = loadbalance;
        this.name = name;
        this.setObjectPools(objectPools);
    }

    public void setLoadbalance(int loadbalance) {
        this.loadbalance = loadbalance;
    }

    public BackendConnectionPool[] getObjectPools() {
        return this.objectPools;
    }

    public void setObjectPools(BackendConnectionPool[] objectPools) {
        this.objectPools = objectPools;
        this.runtimeObjectPools = (BackendConnectionPool[])objectPools.clone();
        if (this.runtimeObjectPools.length > 0) {
            for (int i = 0; i < this.runtimeObjectPools.length; ++i) {
                this.circle.put(HashMod / this.runtimeObjectPools.length * i, this.runtimeObjectPools[i]);
            }
        }
    }

    public BackendConnectionPool getConsistenthashPool(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = function.hash((Object)(key != null ? key.toString() : ""));
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, BackendConnectionPool> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        }
        return (BackendConnectionPool)this.circle.get(hash);
    }

    @Override
    public BackendConnection borrowObject() throws Exception {
        BackendConnectionPool pool = null;
        while (true) {
            BackendConnectionPool[] poolsTemp;
            if ((poolsTemp = this.runtimeObjectPools).length == 0) {
                throw new Exception("poolName=" + this.name + ", no valid pools");
            }
            if (this.loadbalance == 1) {
                long current;
                ++this.currentCount;
                pool = poolsTemp[(int)(current % (long)poolsTemp.length)];
            } else if (this.loadbalance == 2) {
                if (poolsTemp.length > 1) {
                    BackendConnectionPool[] objectPoolsCloned = (BackendConnectionPool[])poolsTemp.clone();
                    Arrays.sort(objectPoolsCloned, this.comparator);
                    pool = objectPoolsCloned[0];
                } else if (poolsTemp.length == 1) {
                    pool = poolsTemp[0];
                }
            } else if (this.loadbalance == 3) {
                pool = this.index < poolsTemp.length ? poolsTemp[this.index] : poolsTemp[0];
            } else {
                throw new Exception("poolName=" + this.name + " loadbalance parameter error,parameter loadbalance in [1,2,3]");
            }
            if (pool.isValid() && !pool.isClosed()) break;
            this.validate();
        }
        return pool.borrowObject();
    }

    @Override
    public int getActive() {
        int active = 0;
        for (BackendConnectionPool pool : this.objectPools) {
            active += pool.getActive();
        }
        return active;
    }

    @Override
    public void deActive(BackendConnection obj) {
        BackendConnection poolableObject = obj;
        BackendConnectionPool pool = poolableObject.getPool();
        pool.deActive(obj);
    }

    @Override
    public void returnObject(BackendConnection obj) {
        BackendConnection poolableObject = obj;
        BackendConnectionPool pool = poolableObject.getPool();
        if (pool != null) {
            pool.returnObject(obj);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean isEnabled) {
        this.enable = isEnabled;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.delayed = new MultipleHeartbeatDelayed(1L, TimeUnit.SECONDS);
        HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.delayed);
        for (BackendConnectionPool pool : this.objectPools) {
            BackendConnection conn = null;
            try {
                conn = pool.borrowObject();
                if (conn instanceof AuthingableBackendConnection) {
                    if (!((AuthingableBackendConnection)conn).isAuthenticated() || conn.isClosed()) {
                        pool.setValid(false);
                        continue;
                    }
                    pool.setValid(true);
                    continue;
                }
                if (conn.isClosed()) {
                    pool.setValid(false);
                    continue;
                }
                pool.setValid(true);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        pool.returnObject(conn);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        this.validate();
    }

    @Override
    public void close() {
        this.closed = true;
        HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.delayed);
    }

    public synchronized boolean validate() {
        ArrayList<BackendConnectionPool> poolList = new ArrayList<BackendConnectionPool>();
        TreeMap<Integer, BackendConnectionPool> hashPool = new TreeMap<Integer, BackendConnectionPool>();
        for (int i = 0; i < this.objectPools.length; ++i) {
            if (!this.objectPools[i].isValid() || this.objectPools[i].isClosed()) continue;
            poolList.add(this.objectPools[i]);
            hashPool.put(HashMod / this.objectPools.length * i, this.objectPools[i]);
        }
        this.runtimeObjectPools = poolList.toArray(new BackendConnectionPool[poolList.size()]);
        BackendConnectionPool[] poolsTemp = this.runtimeObjectPools;
        SortedMap<Integer, BackendConnectionPool> oldPool = this.circle;
        this.circle = hashPool;
        oldPool.clear();
        if (poolsTemp.length == 0) {
            this.setValid(false);
            return false;
        }
        this.setValid(true);
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    static {
        String functionName = System.getProperty("venus.HashFunction.class", DefaultFunction.class.getName());
        try {
            Class<?> clazz = Class.forName(functionName);
            function = (HashFunction)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("hashFunction=" + functionName + " not found,using default:" + DefaultFunction.class.getName(), (Throwable)e);
        }
    }

    public class MultipleHeartbeatDelayed
    extends HeartbeatDelayed {
        public MultipleHeartbeatDelayed(long nsTime, TimeUnit timeUnit) {
            super(nsTime, timeUnit);
        }

        public boolean isCycle() {
            return true;
        }

        public Status doCheck() {
            if (MultipleLoadBalanceBackendConnectionPool.this.validate()) {
                return Status.VALID;
            }
            return Status.INVALID;
        }

        public String getName() {
            return MultipleLoadBalanceBackendConnectionPool.this.getName();
        }
    }

    protected static class ActiveNumComparator
    implements Comparator<BackendConnectionPool> {
        protected ActiveNumComparator() {
        }

        @Override
        public int compare(BackendConnectionPool o1, BackendConnectionPool o2) {
            return o1.getActive() - o2.getActive();
        }
    }

    public static class DefaultFunction
    implements HashFunction {
        public int hash(Object key) {
            if (key == null) {
                return 0;
            }
            return Math.abs(key.hashCode() % HashMod);
        }
    }
}

