/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.AbstractConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.ConnectionConnector;
import com.meidusa.toolkit.util.TimeUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public abstract class BackendConnection
extends AbstractConnection {
    protected String host;
    protected int port;
    protected int localPort;
    protected long idleTimeout;
    protected ConnectionConnector connector;
    protected boolean isFinishConnect;
    private BackendConnectionPool pool;
    private boolean isActive = false;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public BackendConnection(SocketChannel channel) {
        super(channel);
    }

    public boolean isFinishConnect() {
        return this.isFinishConnect;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isIdleTimeout() {
        return TimeUtil.currentTimeMillis() > Math.max(this.lastWriteTime, this.lastReadTime) + this.idleTimeout;
    }

    public void setConnector(ConnectionConnector connector) {
        this.connector = connector;
    }

    public void connect(Selector selector) throws IOException {
        this.channel.register(selector, 8, this);
        this.channel.connect(new InetSocketAddress(this.host, this.port));
    }

    public boolean finishConnect() throws IOException {
        if (this.channel.isConnectionPending()) {
            this.channel.finishConnect();
            this.localPort = this.channel.socket().getLocalPort();
            this.isFinishConnect = true;
            return true;
        }
        return false;
    }

    @Override
    public void handle(byte[] data) {
        try {
            this.handler.handle(this, data);
        }
        catch (Throwable e) {
            this.handleError(16003009, e);
        }
    }

    @Override
    public boolean close() {
        BackendConnectionPool temp;
        boolean closed = super.close();
        if (closed && (temp = this.pool) != null && this.isActive()) {
            temp.deActive(this);
            this.setPool(null);
        }
        return closed;
    }

    @Override
    protected void idleCheck() {
    }

    public BackendConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(BackendConnectionPool pool) {
        this.pool = pool;
    }
}

