/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.MessageHandler;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AuthingableBackendConnection
extends BackendConnection {
    private boolean isAuthenticated;
    private CountDownLatch countdown = new CountDownLatch(1);
    private MessageHandler responseMessageHandler;

    public AuthingableBackendConnection(SocketChannel channel) {
        super(channel);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
        this.setHandler(this.responseMessageHandler);
        if (this.countdown.getCount() > 0L) {
            this.countdown.countDown();
        }
    }

    public boolean waitForAuthenticate(long timeout, TimeUnit unit) {
        if (this.isAuthenticated) {
            return true;
        }
        try {
            this.countdown.await(timeout, unit);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return this.isAuthenticated;
    }

    public MessageHandler getResponseMessageHandler() {
        return this.responseMessageHandler;
    }

    public void setResponseMessageHandler(MessageHandler responseMessageHandler) {
        this.responseMessageHandler = responseMessageHandler;
    }

    @Override
    public boolean close() {
        boolean closed = super.close();
        if (closed && this.countdown.getCount() > 0L) {
            this.countdown.countDown();
        }
        return closed;
    }
}

