/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.buffer.BufferPool;
import com.meidusa.toolkit.net.buffer.BufferQueue;
import com.meidusa.toolkit.util.TimeUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private static final int OP_NOT_READ = -2;
    private static final int OP_NOT_WRITE = -5;
    protected long id;
    protected MessageHandler handler;
    protected final SocketChannel channel;
    protected InetAddress address;
    protected ConnectionManager processor;
    protected SelectionKey processKey;
    protected final ReentrantLock keyLock;
    protected int maxPacketSize;
    protected int readBufferOffset;
    protected ByteBuffer readBuffer;
    protected BufferQueue writeQueue;
    protected final ReentrantLock writeLock;
    protected boolean isRegistered;
    protected final AtomicBoolean isClosed;
    protected boolean isSocketClosed;
    protected long startupTime;
    protected long lastReadTime;
    protected long lastWriteTime;
    protected long netInBytes;
    protected long netOutBytes;
    protected int writeAttempts;

    public AbstractConnection(SocketChannel channel) {
        this.channel = channel;
        this.keyLock = new ReentrantLock();
        this.writeLock = new ReentrantLock();
        this.isClosed = new AtomicBoolean(false);
        this.lastReadTime = this.startupTime = TimeUtil.currentTimeMillis();
        this.lastWriteTime = this.startupTime;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setHandler(MessageHandler<? extends Connection, ?> handler) {
        this.handler = handler;
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public long getNetInBytes() {
        return this.netInBytes;
    }

    public long getNetOutBytes() {
        return this.netOutBytes;
    }

    public int getWriteAttempts() {
        return this.writeAttempts;
    }

    public ConnectionManager getProcessor() {
        return this.processor;
    }

    public void setProcessor(ConnectionManager processor) {
        this.processor = processor;
        this.readBuffer = processor.getBufferPool().allocate();
        this.processor.addConnection(this);
    }

    public ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public BufferQueue getWriteQueue() {
        return this.writeQueue;
    }

    public void setWriteQueue(BufferQueue writeQueue) {
        this.writeQueue = writeQueue;
    }

    public ByteBuffer allocate() {
        return this.processor.getBufferPool().allocate();
    }

    public void recycle(ByteBuffer buffer) {
        this.processor.getBufferPool().recycle(buffer);
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Selector selector) throws IOException {
        try {
            this.processKey = this.channel.register(selector, 1, this);
            this.address = this.channel.socket().getInetAddress();
            this.isRegistered = true;
        }
        finally {
            if (this.isClosed.get()) {
                this.clearSelectionKey();
            }
        }
    }

    @Override
    public void read() throws IOException {
        block6: {
            ByteBuffer buffer = this.readBuffer;
            int got = this.channel.read(buffer);
            this.lastReadTime = TimeUtil.currentTimeMillis();
            if (got < 0) {
                throw new EOFException();
            }
            this.netInBytes += (long)got;
            this.processor.addNetInBytes(got);
            int offset = this.readBufferOffset;
            int length = 0;
            int position = buffer.position();
            while (true) {
                if ((length = this.getPacketLength(buffer, offset)) == -1) {
                    if (buffer.hasRemaining()) break block6;
                    this.checkReadBuffer(buffer, offset, position);
                    break block6;
                }
                if (length == 0) {
                    throw new EOFException("conn=" + this.toString() + ",packet error, length=0!");
                }
                if (position < offset + length) break;
                buffer.position(offset);
                byte[] data = new byte[length];
                buffer.get(data, 0, length);
                this.handle(data);
                if (position == (offset += length)) {
                    if (this.readBufferOffset != 0) {
                        this.readBufferOffset = 0;
                    }
                    buffer.clear();
                    break block6;
                }
                this.readBufferOffset = offset;
                buffer.position(position);
            }
            if (buffer.hasRemaining()) break block6;
            this.checkReadBuffer(buffer, offset, position);
        }
    }

    @Override
    public void write(byte[] data) {
        if (data.length > this.processor.getBufferPool().getChunkSize()) {
            this.write(ByteBuffer.wrap(data));
        } else {
            ByteBuffer buffer = this.allocate();
            buffer.put(data);
            buffer.flip();
            this.write(buffer);
        }
    }

    @Override
    public void write(ByteBuffer buffer) {
        if (this.isClosed.get()) {
            this.processor.getBufferPool().recycle(buffer);
            return;
        }
        if (this.isRegistered) {
            try {
                this.writeQueue.put(buffer);
            }
            catch (InterruptedException e) {
                this.handleError(16003006, e);
                return;
            }
            try {
                this.writeByQueue();
            }
            catch (IOException e) {
                logger.info("write error", (Throwable)e);
                this.close();
            }
        } else {
            this.processor.getBufferPool().recycle(buffer);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByQueue() throws IOException {
        if (this.isClosed.get()) {
            return;
        }
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            if ((this.processKey.interestOps() & 4) == 0 && !this.write0()) {
                this.enableWrite();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByEvent() throws IOException {
        if (this.isClosed.get()) {
            return;
        }
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            if (this.write0() && this.writeQueue.size() == 0) {
                this.disableWrite();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableRead() {
        ReentrantLock lock = this.keyLock;
        lock.lock();
        try {
            SelectionKey key = this.processKey;
            key.interestOps(key.interestOps() | 1);
        }
        finally {
            lock.unlock();
        }
        this.processKey.selector().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableRead() {
        ReentrantLock lock = this.keyLock;
        lock.lock();
        try {
            SelectionKey key = this.processKey;
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
        }
        finally {
            lock.unlock();
        }
    }

    public ByteBuffer checkWriteBuffer(ByteBuffer buffer, int capacity) {
        if (capacity > buffer.remaining()) {
            this.write(buffer);
            return this.processor.getBufferPool().allocate();
        }
        return buffer;
    }

    public ByteBuffer writeToBuffer(byte[] src, ByteBuffer buffer) {
        int offset = 0;
        int remaining = buffer.remaining();
        for (int length = src.length; length > 0; length -= remaining) {
            if (remaining >= length) {
                buffer.put(src, offset, length);
                buffer.flip();
                break;
            }
            buffer.put(src, offset, remaining);
            buffer.flip();
            this.write(buffer);
            buffer = this.processor.getBufferPool().allocate();
            offset += remaining;
            remaining = buffer.remaining();
        }
        return buffer;
    }

    @Override
    public boolean close() {
        if (this.isClosed.get()) {
            return false;
        }
        if (this.closeSocket()) {
            boolean success = this.isClosed.compareAndSet(false, true);
            if (success && this.isRegistered) {
                this.processor.notifyObservers(2, this, null);
                if (logger.isDebugEnabled()) {
                    logger.debug("conn=" + this.toString() + ", closed!!");
                }
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected abstract void idleCheck();

    protected void cleanup() {
        BufferPool pool = this.processor.getBufferPool();
        ByteBuffer buffer = null;
        buffer = this.readBuffer;
        if (buffer != null) {
            this.readBuffer = null;
            pool.recycle(buffer);
        }
        while ((buffer = this.writeQueue.poll()) != null) {
            pool.recycle(buffer);
        }
    }

    protected abstract int getPacketLength(ByteBuffer var1, int var2);

    private ByteBuffer checkReadBuffer(ByteBuffer buffer, int offset, int position) {
        if (offset == 0) {
            if (buffer.capacity() >= this.maxPacketSize) {
                throw new IllegalArgumentException("Packet size over the limit.");
            }
            int size = buffer.capacity() << 1;
            size = size > this.maxPacketSize ? this.maxPacketSize : size;
            ByteBuffer newBuffer = ByteBuffer.allocate(size);
            buffer.position(offset);
            newBuffer.put(buffer);
            this.readBuffer = newBuffer;
            this.processor.getBufferPool().recycle(buffer);
            return newBuffer;
        }
        buffer.position(offset);
        buffer.compact();
        this.readBufferOffset = 0;
        return buffer;
    }

    private boolean write0() throws IOException {
        int written;
        ByteBuffer buffer = this.writeQueue.attachment();
        if (buffer != null) {
            written = this.channel.write(buffer);
            if (written > 0) {
                this.netOutBytes += (long)written;
                this.processor.addNetOutBytes(written);
            }
            this.lastWriteTime = TimeUtil.currentTimeMillis();
            if (buffer.hasRemaining()) {
                ++this.writeAttempts;
                return false;
            }
            this.writeQueue.attach(null);
            this.processor.getBufferPool().recycle(buffer);
        }
        if ((buffer = this.writeQueue.poll()) != null) {
            if (!buffer.hasRemaining()) {
                this.processor.getBufferPool().recycle(buffer);
                this.close();
                return true;
            }
            written = this.channel.write(buffer);
            if (written > 0) {
                this.netOutBytes += (long)written;
                this.processor.addNetOutBytes(written);
            }
            this.lastWriteTime = TimeUtil.currentTimeMillis();
            if (buffer.hasRemaining()) {
                this.writeQueue.attach(buffer);
                ++this.writeAttempts;
                return false;
            }
            this.processor.getBufferPool().recycle(buffer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWrite() {
        ReentrantLock lock = this.keyLock;
        lock.lock();
        try {
            SelectionKey key = this.processKey;
            key.interestOps(key.interestOps() | 4);
        }
        finally {
            lock.unlock();
        }
        this.processKey.selector().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableWrite() {
        ReentrantLock lock = this.keyLock;
        lock.lock();
        try {
            SelectionKey key = this.processKey;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelectionKey() {
        ReentrantLock lock = this.keyLock;
        lock.lock();
        try {
            SelectionKey key = this.processKey;
            if (key != null && key.isValid()) {
                key.attach(null);
                key.cancel();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean closeSocket() {
        this.clearSelectionKey();
        SocketChannel channel = this.channel;
        if (channel != null) {
            boolean isSocketClosed = true;
            Socket socket = channel.socket();
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                isSocketClosed = socket.isClosed();
            }
            try {
                channel.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            return isSocketClosed && !channel.isOpen();
        }
        return true;
    }

    protected boolean isConnectionReset(Throwable t) {
        if (t instanceof IOException) {
            String msg = t.getMessage();
            return msg != null && msg.contains("Connection reset by peer");
        }
        return false;
    }
}

