package com.meidusa.toolkit.net.util;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class InetAddressUtil {
	public static int pack(byte[] bytes) {
		int val = 0;
		for (int i = 0; i < bytes.length; i++) {
			val = ((val << 8) | (bytes[i] & 0xff));
		}
		return val;
	}

	public static  byte[] unpack(int bytes) {
		return new byte[] { (byte) 
				((bytes >>> 24) & 0xff),
				(byte) ((bytes >>> 16) & 0xff), 
				(byte) ((bytes >>> 8) & 0xff),
				(byte) ((bytes) & 0xff) };
	}

	public static void main(String[] args) throws Exception {
		long time = System.nanoTime();
		String host = "127.0.0.1";
		for (int i = 0; i < 1; i++) {
			
			String target = InetAddress.getByAddress(unpack(pack(InetAddress.getByName(host).getAddress()))).getHostName();
			//byte[] bts = InetAddress.getByName(host).getAddress();
			System.out.println(target);
		}
		System.err.println(TimeUnit.MILLISECONDS.convert(System.nanoTime()
				- time, TimeUnit.NANOSECONDS));
	}

}
