package com.meidusa.toolkit.net.authenticate.server;

import com.meidusa.toolkit.net.AuthingableFrontendConnection;
import com.meidusa.toolkit.net.MessageHandler;

public abstract class AuthenticateProvider<T extends AuthingableFrontendConnection> implements MessageHandler<T>{

	public abstract void beforeAuthing(T conn);
	
	
	public void afterAuthing(T conn,boolean isAuthenticated){
		conn.setAuthenticated(isAuthenticated);
		conn.setHandler(conn.getRequestHandler());
	}
	
	
	public abstract void handle(T conn, byte[] message);

}
