/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

import com.meidusa.toolkit.net.config.ExceptionCodeConstant;
import com.meidusa.toolkit.util.TimeUtil;


public abstract class BackendConnection extends AbstractConnection {

    protected String host;
    protected int port;
    protected int localPort;
    protected long idleTimeout;
    protected ConnectionConnector connector;
    protected boolean isFinishConnect;
    private BackendConnectionPool pool;
    private boolean isActive = false;
    
    public boolean isActive() {
		return isActive;
	}

	public void setActive(boolean isActive) {
		this.isActive = isActive;
	}

	public BackendConnection(SocketChannel channel) {
        super(channel);
    }

    public boolean isFinishConnect() {
		return isFinishConnect;
	}

	public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getLocalPort() {
        return localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

	public long getIdleTimeout() {
        return idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isIdleTimeout() {
        return TimeUtil.currentTimeMillis() > Math.max(lastWriteTime, lastReadTime) + idleTimeout;
    }

    public void setConnector(ConnectionConnector connector) {
        this.connector = connector;
    }

    public void connect(Selector selector) throws IOException {
        channel.register(selector, SelectionKey.OP_CONNECT, this);
        channel.connect(new InetSocketAddress(host, port));
    }

    public boolean finishConnect() throws IOException {
        if (channel.isConnectionPending()) {
            channel.finishConnect();
            localPort = channel.socket().getLocalPort();
            isFinishConnect = true;
            return true;
        } else {
            return false;
        }
    }

    @SuppressWarnings("unchecked")
	@Override
    public void handle(byte[] data) {
        try {
            handler.handle(this,data);
        } catch (Throwable e) {
            handleError(ExceptionCodeConstant.ERR_HANDLE_DATA, e);
        }
    }
    
    public boolean close() {
        boolean closed = super.close();
        if (closed) {
        	if(pool != null){
        		if(isActive()){
        			pool.deActive(this);
            		this.setPool(null);
        		}
        	}
        }
        return closed;
    }
    
    @Override
    protected void idleCheck() {
        // nothing
    }

	public BackendConnectionPool getPool() {
		return pool;
	}

	public void setPool(BackendConnectionPool pool) {
		this.pool = pool;
	}

}
