/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger(LoopingThread.class);
    protected boolean _running = true;

    public LoopingThread() {
    }

    public LoopingThread(String name) {
        super(name);
    }

    public synchronized void shutdown() {
        this._running = false;
        if (this != Thread.currentThread()) {
            this.kick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info(this.getName() + " LoopingThread willStart....");
        try {
            this.willStart();
            while (this.isRunning()) {
                try {
                    this.iterate();
                }
                catch (Throwable e) {
                    this.handleIterateFailure(e);
                }
            }
        }
        finally {
            this.didShutdown();
        }
    }

    public synchronized boolean isRunning() {
        return this._running;
    }

    protected void kick() {
    }

    protected void willStart() {
    }

    protected void iterate() throws Throwable {
        throw new RuntimeException("Derived class must implement iterate().");
    }

    protected void handleIterateFailure(Throwable e) {
        log.error("Thread Shutdown! due to the error:", e);
        this.shutdown();
    }

    protected void didShutdown() {
    }
}

