/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.common.util.CharsetCache;
import com.meidusa.toolkit.net.IllegalPacketException;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class GenericIOPacketBuffer
extends AbstractPacketBuffer {
    public abstract int getHeadSize();

    public GenericIOPacketBuffer(byte[] buf) {
        super(buf);
    }

    public GenericIOPacketBuffer(int size) {
        super(size);
    }

    public final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        this.readBytes(b);
        return b;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] dest = new byte[len];
        System.arraycopy(this.data, offset, dest, 0, len);
        return dest;
    }

    public abstract int readFieldLength();

    public final int readInt() {
        return (this.data[this.position++] & 0xFF) << 24 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 0;
    }

    public final void writeInt(int i) {
        this.ensureCapacity(4);
        this.position = GenericIOPacketBuffer.writeInt(this.data, this.position, i);
    }

    public static final int readInt(byte[] data, int position) {
        return (data[position++] & 0xFF) << 24 | (data[position++] & 0xFF) << 16 | (data[position++] & 0xFF) << 8 | (data[position++] & 0xFF) << 0;
    }

    public static final int writeInt(byte[] data, int position, int i) {
        data[position++] = (byte)(i >> 24);
        data[position++] = (byte)(i >> 16);
        data[position++] = (byte)(i >> 8);
        data[position++] = (byte)(i >> 0);
        return position;
    }

    public final long readLong() {
        return ((long)this.data[this.position++] & 0xFFL) << 56 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 0;
    }

    public static final long readLong(byte[] data, int position) {
        return ((long)data[position++] & 0xFFL) << 56 | ((long)data[position++] & 0xFFL) << 48 | ((long)data[position++] & 0xFFL) << 40 | ((long)data[position++] & 0xFFL) << 32 | ((long)data[position++] & 0xFFL) << 24 | ((long)data[position++] & 0xFFL) << 16 | ((long)data[position++] & 0xFFL) << 8 | ((long)data[position++] & 0xFFL) << 0;
    }

    public final void writeLong(long i) {
        this.ensureCapacity(8);
        this.position = GenericIOPacketBuffer.writeLong(this.data, this.position, i);
    }

    public static final int writeLong(byte[] data, int position, long i) {
        data[position++] = (byte)(i >> 56);
        data[position++] = (byte)(i >> 48);
        data[position++] = (byte)(i >> 40);
        data[position++] = (byte)(i >> 32);
        data[position++] = (byte)(i >> 24);
        data[position++] = (byte)(i >> 16);
        data[position++] = (byte)(i >> 8);
        data[position++] = (byte)(i >> 0);
        return position;
    }

    public int writeLengthCodedBytes(byte[] ab) {
        if (ab == null) {
            this.ensureCapacity(4);
        } else {
            this.ensureCapacity(ab.length + 4);
        }
        this.writeInt(ab == null ? 0 : ab.length);
        if (ab != null && ab.length > 0) {
            return this.writeBytes(ab, 0, ab.length);
        }
        return 0;
    }

    public void skipLengthCodedBytes() {
        int count = this.readInt();
        if (count == 0) {
            return;
        }
        if (count > this.remaining()) {
            throw new IllegalPacketException("packet content size error: " + count + ">" + this.remaining() + " remaining");
        }
        this.skip(count);
    }

    public byte[] readLengthCodedBytes() {
        int count = this.readInt();
        if (count == 0) {
            return new byte[0];
        }
        if (count > this.remaining()) {
            throw new IllegalPacketException("packet content size error: " + count + ">" + this.remaining() + " remaining");
        }
        byte[] bts = new byte[count];
        this.readBytes(bts, 0, count);
        return bts;
    }

    public final String readLengthCodedString(Charset charset) {
        int fieldLength = this.readFieldLength();
        if (fieldLength == 0) {
            return null;
        }
        if (fieldLength > this.length - this.position) {
            throw new IllegalPacketException("fieldLength error Buffer.Remaining=" + this.remaining() + " ,but need size=" + fieldLength);
        }
        byte[] bytes = this.getBytes(fieldLength);
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes);
    }

    public final String readLengthCodedString(String encoding) {
        Charset charset = CharsetCache.getCharset((String)encoding);
        return this.readLengthCodedString(charset);
    }

    public String toSuperString() {
        return super.toString();
    }

    public abstract void writeFieldLength(int var1);

    public short readShort() {
        return (short)((this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF);
    }

    public void writeShort(short i) {
        this.ensureCapacity(2);
        this.position = GenericIOPacketBuffer.writeShort(this.data, this.position, i);
    }

    public static final int writeShort(byte[] data, int position, short i) {
        data[position++] = (byte)(i >> 8);
        data[position++] = (byte)(i >> 0);
        return position;
    }

    public final void writeLengthCodedString(String s, String encoding) {
        Charset charset = CharsetCache.getCharset((String)encoding);
        this.writeLengthCodedString(s, charset);
    }

    public final void writeLengthCodedString(String s, Charset charset) {
        if (s != null) {
            byte[] b = s.getBytes(charset);
            this.ensureCapacity(b.length + 9);
            this.writeFieldLength(b.length);
            this.writeBytes(b);
        } else {
            this.writeFieldLength(0);
        }
    }

    public final void writeString(String s) {
        try {
            this.writeString(s, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public final void writeString(String s, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = null;
        bytes = encoding == null ? s.getBytes() : s.getBytes(encoding);
        this.ensureCapacity(bytes.length + 1 + 8);
        this.writeFieldLength(bytes.length);
        this.writeBytes(bytes);
    }
}

