/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

public final class BufferPool {
    private final int chunkSize;
    private final ByteBuffer[] items;
    private final ReentrantLock lock;
    private int putIndex;
    private int takeIndex;
    private int count;
    private volatile int newCount;

    public BufferPool(int bufferSize, int chunkSize) {
        this.chunkSize = chunkSize;
        int capacity = bufferSize / chunkSize;
        capacity = bufferSize % chunkSize == 0 ? capacity : capacity + 1;
        this.items = new ByteBuffer[capacity];
        this.lock = new ReentrantLock();
        for (int i = 0; i < capacity; ++i) {
            this.insert(this.create(chunkSize));
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int capacity() {
        return this.items.length;
    }

    public int size() {
        return this.count;
    }

    public int getNewCount() {
        return this.newCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate() {
        ByteBuffer node = null;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            node = this.count == 0 ? null : this.extract();
        }
        finally {
            lock.unlock();
        }
        if (node == null) {
            ++this.newCount;
            return this.create(this.chunkSize);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(ByteBuffer buffer) {
        if (buffer == null || buffer.capacity() > this.chunkSize) {
            return;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count < this.items.length) {
                buffer.clear();
                this.insert(buffer);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void insert(ByteBuffer buffer) {
        this.items[this.putIndex] = buffer;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
    }

    private ByteBuffer extract() {
        ByteBuffer[] items = this.items;
        ByteBuffer item = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        return item;
    }

    private int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private ByteBuffer create(int size) {
        return ByteBuffer.allocate(size);
    }
}

