/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

/**
 * 弱精度的计时器，考虑性能不使用同步策略。
 */
public class TimeUtil {
	private static final long TIME_UPDATE_PERIOD = 1L;
    private static long CURRENT_TIME = System.currentTimeMillis();
    private final static Timer timer = new Timer("TimerUtil", true);
    static {
    	 timer.schedule(updateTime(), 0L, TIME_UPDATE_PERIOD);
    }
    private TimeUtil(){}
    public static final long currentTimeMillis() {
        return CURRENT_TIME;
    }

    private static final void update() {
        CURRENT_TIME = System.currentTimeMillis();
    }

    private static TimerTask updateTime() {
        return new TimerTask() {
            @Override
            public void run() {
                TimeUtil.update();
            }
        };
    }
    
    public static void main(String[] args) throws Exception {
    	System.out.println(TimeUtil.currentTimeMillis());
    	System.out.println(new Date(1403677154534L));
    	Thread.sleep(1000L);
    	System.out.println(TimeUtil.currentTimeMillis());
    	Thread.sleep(1000L);
    	System.out.println(TimeUtil.currentTimeMillis());
    	Thread.sleep(1000L);
    	System.out.println(TimeUtil.currentTimeMillis());
    	Thread.sleep(1000L);
    	System.out.println(TimeUtil.currentTimeMillis());
    	Thread.sleep(1000L);
    	System.out.println(TimeUtil.currentTimeMillis());
    	
	}
}


