package com.meidusa.toolkit.net.factory;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.util.CreateConnectionException;
import com.meidusa.toolkit.util.TimeUtil;

public abstract class AuthingableBackendConnectionFactory extends
		BackendConnectionFactory {
	private static long WAITTIMEOUT = 5;
	public BackendConnection make() throws IOException {
		BackendConnection c = super.make();
		AuthingableBackendConnection conn = (AuthingableBackendConnection) c;
		long start = TimeUtil.currentTimeMillis();
		if(!conn.waitForAuthenticate(WAITTIMEOUT,TimeUnit.SECONDS)){
			conn.close();
			long end = TimeUtil.currentTimeMillis();
			boolean isTimeout =  (start-end) >= TimeUnit.MILLISECONDS.convert(WAITTIMEOUT, TimeUnit.SECONDS);
			String msg = (isTimeout?", timeout!":"");
			throw new CreateConnectionException(conn.isFinishConnect()?("authenticate error to "+c.getHost()+":"+c.getPort() +msg):(" cannot connect to "+c.getHost()+":"+c.getPort()+msg));
		}
		return conn;
	}

}
